/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.storage;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mindrot.jbcrypt.BCrypt;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.storage.StorageProvider;

@OnlyIn(value=Dist.DEDICATED_SERVER)
@ThreadSafe
public class StorageProviderFile
implements StorageProvider {
    private final Gson gson = new Gson();
    private final Path path;
    private final Map<String, POJOUserEntry> entries = new ConcurrentHashMap<String, POJOUserEntry>();
    private boolean dirty = false;

    public StorageProviderFile(Path path) throws IOException {
        this.path = path;
        if (Files.exists(path, new LinkOption[0])) {
            POJOUserEntry[] buf = (POJOUserEntry[])this.gson.fromJson((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8), POJOUserEntry[].class);
            if (buf != null) {
                Arrays.stream(buf).peek(e -> {
                    e.username = e.username.toLowerCase();
                }).forEach(e -> this.entries.put(e.username, (POJOUserEntry)e));
            }
        } else {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    @Override
    public boolean checkPassword(String username, String password) {
        if (this.entries.containsKey(username)) {
            return BCrypt.checkpw((String)password, (String)this.entries.get((Object)username).password);
        }
        return false;
    }

    @Override
    public void unregister(String username) {
        this.dirty = true;
        this.entries.remove(username);
    }

    @Override
    public boolean registered(String username) {
        return this.entries.containsKey(username);
    }

    @Override
    public void register(String username, String password) {
        if (!this.entries.containsKey(username)) {
            this.entries.put(username, StorageProviderFile.newEntry(username, BCrypt.hashpw((String)password, (String)BCrypt.gensalt())));
            this.dirty = true;
        }
    }

    @Override
    public synchronized void save() throws IOException {
        try {
            Files.writeString(this.path, (CharSequence)this.gson.toJson((Object)this.entries.values().toArray()), StandardOpenOption.TRUNCATE_EXISTING);
            this.dirty = false;
        }
        catch (IOException ex) {
            SimpleLogin.logger.error("Unable to save entries", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public GameType gameType(String username) {
        return GameType.m_46393_((int)this.entries.get((Object)username).gameType);
    }

    @Override
    public void setGameType(String username, GameType gameType) {
        if (this.entries.containsKey(username)) {
            this.dirty = true;
            this.entries.get((Object)username).gameType = gameType.m_46392_();
        }
    }

    @Override
    public void changePassword(String username, String newPassword) {
        if (this.entries.containsKey(username)) {
            this.dirty = true;
            this.entries.get((Object)username).password = BCrypt.hashpw((String)newPassword, (String)BCrypt.gensalt());
        }
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    @Override
    public Collection<String> getAllRegisteredUsername() {
        return new ImmutableList.Builder().addAll(this.entries.keySet()).build();
    }

    private static POJOUserEntry newEntry(String username, String password) {
        POJOUserEntry entry = new POJOUserEntry();
        entry.username = username;
        entry.password = password;
        entry.gameType = (Integer)SLConfig.SERVER.defaultGameType.get();
        return entry;
    }

    private static class POJOUserEntry {
        public String password;
        public String username;
        public int gameType;

        private POJOUserEntry() {
        }
    }
}

