/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.dynmap.DynmapCore;
import org.dynmap.Log;

public class Event<T> {
    private List<Listener<T>> listeners = new LinkedList<Listener<T>>();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener<T> l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener<T> l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(T t) {
        ArrayList<Listener<T>> iterlist;
        Iterator<Listener<T>> iterator = this.lock;
        synchronized (iterator) {
            iterlist = new ArrayList<Listener<T>>(this.listeners);
        }
        for (Listener<T> l : iterlist) {
            l.triggered(t);
        }
    }

    public boolean triggerSync(DynmapCore core, final T t) {
        Future future = core.getServer().callSyncMethod(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Event.this.trigger(t);
                return t;
            }
        });
        boolean success = false;
        try {
            if (future != null) {
                future.get();
                success = true;
            }
        }
        catch (ExecutionException ix) {
            Log.severe("Exception in triggerSync", ix.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return success;
    }

    public static interface Listener<T> {
        public void triggered(T var1);
    }
}

