/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public enum DataWriter implements IDataWriter
{
    INSTANCE;

    private CompoundTag raw;
    private final Map<Class<IData>, List<Consumer<IDataWriter.Result<IData>>>> typed = new HashMap<Class<IData>, List<Consumer<IDataWriter.Result<IData>>>>();
    private boolean clean;

    public CompoundTag reset() {
        if (this.clean) {
            return this.raw;
        }
        this.raw = new CompoundTag();
        this.clean = true;
        this.typed.values().forEach(List::clear);
        return this.raw;
    }

    public void sendTypedPackets(final PacketSender sender, ServerPlayer player) {
        this.typed.forEach((type, data) -> {
            final ResourceLocation id = Registrar.INSTANCE.dataType2Id.get(type);
            final boolean[] finished = new boolean[]{false};
            for (Consumer consumer : data) {
                try {
                    consumer.accept(new IDataWriter.Result<IData>(){
                        boolean added = false;

                        @Override
                        public IDataWriter.Result<IData> add(IData data) {
                            Preconditions.checkState((!this.added ? 1 : 0) != 0, (Object)"Called multiple times in the same closure");
                            Preconditions.checkNotNull((Object)data, (Object)"Data is null");
                            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                            buf.m_130085_(id);
                            data.write(buf);
                            sender.send(Packets.DATA_TYPED, buf);
                            finished[0] = true;
                            this.added = true;
                            return this;
                        }

                        @Override
                        public IDataWriter.Result<IData> block() {
                            finished[0] = true;
                            return this;
                        }
                    });
                }
                catch (Throwable t) {
                    if (ExceptionUtil.dump(t, consumer.getClass().toString() + "\nplayer " + player.m_6302_(), null)) {
                        player.m_213846_((Component)Component.m_237113_((String)("Error on retrieving server data from provider " + consumer.getClass().getName())));
                    }
                    finished[0] = true;
                }
                if (!finished[0]) continue;
                break;
            }
        });
    }

    @Override
    public CompoundTag raw() {
        this.clean = false;
        return this.raw;
    }

    @Override
    public <T extends IData> void add(Class<T> type, Consumer<IDataWriter.Result<T>> consumer) {
        Preconditions.checkArgument((boolean)Registrar.INSTANCE.dataType2Id.containsKey(type), (Object)"Data type is not registered");
        this.clean = false;
        this.typed.computeIfAbsent((Class)TypeUtil.uncheckedCast(type), t -> new ArrayList()).add((Consumer)TypeUtil.uncheckedCast(consumer));
    }
}

