/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import io.netty.buffer.Unpooled;
import java.util.List;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.Register;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ComponentHandler {
    public static void gatherBlock(DataAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (blockEntity != null && accessor.isTimeElapsed(rate) && Waila.CONFIG.get().getGeneral().isDisplayTooltip()) {
            accessor.resetTimer();
            if (!registrar.blockData.get(block).isEmpty() || !registrar.blockData.get(blockEntity).isEmpty()) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130062_(accessor.getBlockHitResult());
                PacketSender.c2s().send(Packets.BLOCK, buf);
            }
        }
        ComponentHandler.handleBlock(accessor, tooltip, block, position);
        ComponentHandler.handleBlock(accessor, tooltip, blockEntity, position);
    }

    private static void handleBlock(DataAccessor accessor, Tooltip tooltip, Object obj, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        List<Register.Entry<IBlockComponentProvider>> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (Register.Entry<IBlockComponentProvider> entry : providers) {
            IBlockComponentProvider provider = entry.value();
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static void gatherEntity(Entity entity, DataAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        Object trueEntity = accessor.getEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (trueEntity != null && accessor.isTimeElapsed(rate)) {
            accessor.resetTimer();
            if (!registrar.entityData.get(trueEntity).isEmpty()) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130130_(entity.m_19879_());
                Vec3 hitPos = accessor.getEntityHitResult().m_82450_();
                buf.writeDouble(hitPos.f_82479_);
                buf.writeDouble(hitPos.f_82480_);
                buf.writeDouble(hitPos.f_82481_);
                PacketSender.c2s().send(Packets.ENTITY, buf);
            }
        }
        List<Register.Entry<IEntityComponentProvider>> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (Register.Entry<IEntityComponentProvider> entry : providers) {
            IEntityComponentProvider provider = entry.value();
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static ITooltipComponent getIcon(HitResult target) {
        Registrar registrar = Registrar.INSTANCE;
        DataAccessor data = DataAccessor.INSTANCE;
        PluginConfig config = PluginConfig.CLIENT;
        if (target.m_6662_() == HitResult.Type.ENTITY) {
            List<Register.Entry<IEntityComponentProvider>> providers = registrar.entityIcon.get(data.getEntity());
            for (Register.Entry<IEntityComponentProvider> provider : providers) {
                ITooltipComponent icon = provider.value().getIcon(data, config);
                if (icon == null) continue;
                return icon;
            }
        } else {
            Object blockEntity;
            BlockState state = data.getBlockState();
            if (state.m_60795_()) {
                return EmptyComponent.INSTANCE;
            }
            ITooltipComponent result = null;
            int priority = 0;
            for (Register.Entry<IBlockComponentProvider> provider : registrar.blockIcon.get(state.m_60734_())) {
                ITooltipComponent icon = provider.value().getIcon(DataAccessor.INSTANCE, PluginConfig.CLIENT);
                if (icon == null) continue;
                result = icon;
                priority = provider.priority();
                break;
            }
            if ((blockEntity = data.getBlockEntity()) != null) {
                for (Register.Entry<IBlockComponentProvider> provider : registrar.blockIcon.get(blockEntity)) {
                    if (provider.priority() >= priority) break;
                    ITooltipComponent icon = provider.value().getIcon(DataAccessor.INSTANCE, PluginConfig.CLIENT);
                    if (icon == null) continue;
                    result = icon;
                    break;
                }
            }
            if (result != null) {
                return result;
            }
        }
        return EmptyComponent.INSTANCE;
    }

    public static Entity getOverrideEntity(HitResult target) {
        if (target == null || target.m_6662_() != HitResult.Type.ENTITY) {
            return null;
        }
        Registrar registrar = Registrar.INSTANCE;
        Entity entity = ((EntityHitResult)target).m_82443_();
        List<Register.Entry<IEntityComponentProvider>> overrideProviders = registrar.entityOverride.get(entity);
        for (Register.Entry<IEntityComponentProvider> provider : overrideProviders) {
            Entity override = provider.value().getOverride(DataAccessor.INSTANCE, PluginConfig.CLIENT);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static BlockState getOverrideBlock(HitResult target) {
        Registrar registrar = Registrar.INSTANCE;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return null;
        }
        BlockPos pos = ((BlockHitResult)target).m_82425_();
        BlockState state = world.m_8055_(pos);
        BlockState override = null;
        int priority = 0;
        List<Register.Entry<IBlockComponentProvider>> providers = registrar.blockOverride.get(state.m_60734_());
        for (Register.Entry<IBlockComponentProvider> provider : providers) {
            BlockState blockOverride = provider.value().getOverride(DataAccessor.INSTANCE, PluginConfig.CLIENT);
            if (blockOverride == null) continue;
            override = blockOverride;
            priority = provider.priority();
            break;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (Register.Entry<IBlockComponentProvider> provider : providers) {
            if (provider.priority() >= priority) break;
            BlockState beOverride = provider.value().getOverride(DataAccessor.INSTANCE, PluginConfig.CLIENT);
            if (beOverride == null) continue;
            override = beOverride;
            break;
        }
        return override != null ? override : state;
    }
}

