/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.ComponentHandler;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.mixin.PlayerTabOverlayAccess;
import mcp.mobius.waila.pick.PickerAccessor;
import mcp.mobius.waila.pick.PickerResults;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class TooltipHandler {
    private static final ConfigTooltipRendererState STATE = new ConfigTooltipRendererState();
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Component SNEAK_DETAIL = Component.m_237115_((String)"tooltip.waila.sneak_for_details").m_130940_(ChatFormatting.ITALIC);

    public static void tick() {
        TooltipHandler.STATE.render = false;
        Minecraft client = Minecraft.m_91087_();
        WailaConfig.General config = Waila.CONFIG.get().getGeneral();
        if (client.f_91066_.f_92062_) {
            return;
        }
        if (client.f_91080_ != null && !(client.f_91080_ instanceof ChatScreen)) {
            return;
        }
        if (client.f_91073_ == null || !config.isDisplayTooltip()) {
            return;
        }
        if (config.getDisplayMode() == IWailaConfig.General.DisplayMode.HOLD_KEY && !WailaClient.keyShowOverlay.m_90857_()) {
            return;
        }
        if (config.isHideFromPlayerList() && ((PlayerTabOverlayAccess)client.f_91065_.m_93088_()).wthit_isVisible()) {
            return;
        }
        if (config.isHideFromDebug() && client.f_91066_.f_92063_) {
            return;
        }
        if (client.f_91072_ == null) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        PickerResults results = PickerResults.get();
        Registrar.INSTANCE.picker.pick(PickerAccessor.of(client, client.f_91075_, client.f_91072_.m_105286_(), client.m_91296_()), results, PluginConfig.CLIENT);
        for (HitResult target : results) {
            DataAccessor accessor = DataAccessor.INSTANCE;
            accessor.set((Level)client.f_91073_, (Player)player, target, client.f_91075_, client.m_91296_());
            TooltipRenderer.beginBuild(STATE);
            if (target.m_6662_() == HitResult.Type.BLOCK) {
                BlockState state;
                Object blockEntity;
                Block block = accessor.getBlock();
                if (!(block instanceof LiquidBlock) ? !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK) : !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID)) continue;
                if (IBlacklistConfig.get().contains(block) || (blockEntity = accessor.getBlockEntity()) != null && IBlacklistConfig.get().contains((BlockEntity)blockEntity) || (state = ComponentHandler.getOverrideBlock(target)) == IBlockComponentProvider.EMPTY_BLOCK_STATE) continue;
                accessor.setState(state);
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.HEAD);
                TooltipRenderer.add(TOOLTIP);
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.BODY);
                if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.m_6144_()) {
                    if (!config.isHideShiftText()) {
                        TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                    }
                } else {
                    TooltipRenderer.add(TOOLTIP);
                }
                TOOLTIP.clear();
                ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.TAIL);
            } else if (target.m_6662_() == HitResult.Type.ENTITY) {
                Entity targetEnt;
                Object actualEntity;
                if (!PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY) || (actualEntity = accessor.getEntity()) == null || IBlacklistConfig.get().contains((Entity)actualEntity) || (targetEnt = ComponentHandler.getOverrideEntity(target)) == IEntityComponentProvider.EMPTY_ENTITY) continue;
                accessor.setEntity(targetEnt);
                if (targetEnt == null) continue;
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.HEAD);
                TooltipRenderer.add(TOOLTIP);
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.BODY);
                if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.m_6144_()) {
                    if (!config.isHideShiftText()) {
                        TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                    }
                } else {
                    TooltipRenderer.add(TOOLTIP);
                }
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.TAIL);
            }
            TooltipRenderer.add(TOOLTIP);
            if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON)) {
                TooltipRenderer.setIcon(ComponentHandler.getIcon(target));
            }
            TooltipHandler.STATE.render = true;
            TooltipRenderer.endBuild();
            break;
        }
    }

    private static class ConfigTooltipRendererState
    implements TooltipRenderer.State {
        private boolean render;

        private ConfigTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return this.render;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        private WailaConfig.Overlay getOverlay() {
            return Waila.CONFIG.get().getOverlay();
        }

        @Override
        public int getFps() {
            return this.getOverlay().getFps();
        }

        @Override
        public float getScale() {
            return this.getOverlay().getScale();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return this.getOverlay().getPosition().getAnchor().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return this.getOverlay().getPosition().getAnchor().getY();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return this.getOverlay().getPosition().getAlign().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return this.getOverlay().getPosition().getAlign().getY();
        }

        @Override
        public int getX() {
            return this.getOverlay().getPosition().getX();
        }

        @Override
        public int getY() {
            return this.getOverlay().getPosition().getY();
        }

        @Override
        public boolean bossBarsOverlap() {
            return this.getOverlay().getPosition().isBossBarsOverlap();
        }

        @Override
        public ITheme getTheme() {
            return this.getOverlay().getColor().getTheme();
        }

        @Override
        public int getBackgroundAlpha() {
            return this.getOverlay().getColor().getBackgroundAlpha();
        }

        @Override
        public boolean enableTextToSpeech() {
            return Waila.CONFIG.get().getGeneral().isEnableTextToSpeech();
        }
    }
}

