/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeAccessor;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

class ThemeEditorScreen
extends ConfigScreen {
    private final WailaConfigScreen parent;
    private final ThemeDefinition<?> template;
    private final boolean edit;
    private final TooltipRenderer.State previewState;
    private ThemeType<?> type;
    private ITheme theme;
    private ConfigListWidget options;
    private ButtonEntry refreshButton;
    private InputValue<String> idVal;
    private CycleValue typeVal;
    private final Map<ThemeType<?>, Map<String, Object>> type2attr = new HashMap();
    private final Map<String, ConfigValue<Object>> attrValues = new HashMap<String, ConfigValue<Object>>();

    public ThemeEditorScreen(WailaConfigScreen parent, ThemeDefinition<?> template, boolean edit) {
        super(parent, CommonComponents.f_237098_, () -> {}, () -> {});
        this.parent = parent;
        this.template = template;
        this.edit = edit;
        this.previewState = new PreviewTooltipRendererState();
        this.type = template.type;
        this.type2attr.put(this.type, new HashMap(this.type.properties.size()));
        this.type.properties.forEach((key, prop) -> this.type2attr.get(this.type).put((String)key, prop.get(template.instance)));
        this.buildTheme();
    }

    private void buildTheme() {
        this.theme = this.type.create(this.type2attr.get(this.type));
        this.theme.processProperties(ThemeAccessor.INSTANCE);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.parent.buildPreview(this.previewState);
    }

    @Override
    public ConfigListWidget getOptions() {
        this.options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, this.parent.buildPreview((TooltipRenderer.State)this.previewState).height * 2 + 4, this.f_96544_ - 32, 26, () -> {});
        if (this.idVal == null) {
            this.idVal = new InputValue<String>("config.waila.overlay_theme_editor.id", this.edit ? this.template.id.toString() : "", null, val -> {}, InputValue.IDENTIFIER);
        }
        if (this.edit) {
            this.idVal.disable(null);
        }
        if (this.typeVal == null) {
            this.typeVal = new CycleValue("config.waila.overlay_theme_editor.type", (String[])Registrar.INSTANCE.themeTypes.keySet().stream().map(ResourceLocation::toString).sorted(String::compareToIgnoreCase).toArray(String[]::new), this.type.getId().toString(), val -> {}, false){

                @Override
                public void setValue(String value) {
                    if (ThemeEditorScreen.this.options.save(true)) {
                        super.setValue(value);
                        ThemeEditorScreen.this.type = (ThemeType)Registrar.INSTANCE.themeTypes.get((Object)new ResourceLocation(value));
                        ThemeEditorScreen.this.options.m_6702_().removeIf(it -> it.category.equals(I18n.m_118938_((String)"config.waila.overlay_theme_editor.attributes", (Object[])new Object[0])));
                        ThemeEditorScreen.this.addTypeProperties(ThemeEditorScreen.this.options);
                        ThemeEditorScreen.this.options.init();
                        ThemeEditorScreen.this.options.m_7522_((GuiEventListener)this);
                        this.m_7522_(this.getListener());
                    }
                }
            };
        }
        this.refreshButton = new ButtonEntry("config.waila.overlay_theme_editor.refresh", 100, 20, button -> {
            if (this.options.save(false)) {
                this.buildTheme();
                this.options.resize(this.parent.buildPreview((TooltipRenderer.State)this.previewState).height * 2 + 4, this.f_96544_ - 32);
                this.options.init();
                this.type.properties.forEach((key, prop) -> this.attrValues.get(key).setValue(prop.get(this.theme)));
                this.options.m_7522_((GuiEventListener)this.refreshButton);
                this.refreshButton.m_7522_((GuiEventListener)button);
            }
        });
        this.options.with(this.refreshButton).with(this.idVal).with(this.typeVal);
        if (this.edit) {
            this.options.with(new CategoryEntry("config.waila.overlay_theme_editor.delete")).with(new ButtonEntry("config.waila.overlay_theme_editor.delete", 100, 20, button -> this.f_96541_.m_91152_((Screen)new ConfirmScreen(delete -> {
                if (delete) {
                    this.parent.removeTheme(this.template.id);
                    this.f_96541_.m_91152_((Screen)this.parent);
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237110_((String)"config.waila.overlay_theme_editor.delete_prompt", (Object[])new Object[]{this.template.id}), CommonComponents.f_237098_))));
        }
        this.addTypeProperties(this.options);
        this.options.getSearchBox().f_93623_ = false;
        this.options.getSearchBox().m_94186_(false);
        return this.options;
    }

    private void addTypeProperties(ConfigListWidget options) {
        CategoryEntry category = new CategoryEntry("config.waila.overlay_theme_editor.attributes");
        options.add(options.m_6702_().size() - (this.edit ? 2 : 0), category);
        this.attrValues.clear();
        this.type2attr.computeIfAbsent(this.type, t -> new HashMap(t.properties.size()));
        this.type.properties.forEach((key, prop) -> {
            ConfigValue value;
            Class propType = prop.type;
            Map<String, Object> attr = this.type2attr.get(this.type);
            Object templateValue = attr.computeIfAbsent((String)key, k -> prop.defaultValue);
            if (propType == Integer.TYPE) {
                value = new IntInputValue(prop.getTlKey(), (Integer)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), (IntFormat)TypeUtil.uncheckedCast(prop.context));
            } else if (propType == Boolean.TYPE) {
                value = new BooleanValue(prop.getTlKey(), (Boolean)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val));
            } else if (propType == Double.TYPE) {
                value = new InputValue<Object>(prop.getTlKey(), TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), InputValue.DECIMAL);
            } else if (propType == String.class) {
                value = new InputValue<Object>(prop.getTlKey(), TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), InputValue.ANY);
            } else if (propType.isEnum()) {
                value = new EnumValue(prop.getTlKey(), (Enum[])TypeUtil.uncheckedCast(propType.getEnumConstants()), (Enum)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val));
            } else {
                throw new IllegalArgumentException("Invalid property type " + propType.getSimpleName());
            }
            value.setId((String)key);
            value.category = category.category;
            this.attrValues.put((String)key, (ConfigValue)((Object)((Object)TypeUtil.uncheckedCast((Object)value))));
            options.add(options.m_6702_().size() - (this.edit ? 2 : 0), value);
        });
    }

    @Override
    protected void renderForeground(GuiGraphics ctx, int rowLeft, int rowWidth, int mouseX, int mouseY, float partialTicks) {
        TooltipRenderer.render(ctx, partialTicks);
    }

    @Override
    public void m_7379_() {
        if (this.cancelled) {
            TooltipRenderer.resetState();
            super.m_7379_();
            return;
        }
        if (((String)this.idVal.getValue()).isBlank()) {
            this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"config.waila.missing_input"), (Component)Component.m_237115_((String)"config.waila.overlay_theme_editor.id_empty")));
        } else {
            ResourceLocation id = new ResourceLocation((String)this.idVal.getValue());
            if (id.m_135827_().equals("minecraft") && !((String)this.idVal.getValue()).startsWith("minecraft:")) {
                id = new ResourceLocation("custom", id.m_135815_());
            }
            this.parent.addTheme(new ThemeDefinition(id, this.type, false, this.type2attr.get(this.type)));
            TooltipRenderer.resetState();
            super.m_7379_();
        }
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public int getFps() {
            return 0;
        }

        @Override
        public float getScale() {
            return 2.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 1;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public int getBackgroundAlpha() {
            return 255;
        }

        @Override
        public ITheme getTheme() {
            return ThemeEditorScreen.this.theme;
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }
    }
}

