/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
extends ConfigListWidget.Entry {
    protected final Consumer<T> save;
    protected final String translationKey;
    @Nullable
    protected final T defaultValue;
    protected final T initialValue;
    private final MutableComponent title;
    private final String description;
    private final Button resetButton;
    @Nullable
    private String disabledReason = null;
    private boolean disabled = false;
    @Nullable
    private String id;
    private T value;
    private int x;

    public ConfigValue(String translationKey, T value, @Nullable T defaultValue, Consumer<T> save) {
        this.translationKey = translationKey;
        this.title = Component.m_237115_((String)translationKey);
        this.description = translationKey + "_desc";
        this.initialValue = value;
        this.value = value;
        this.save = save;
        this.defaultValue = defaultValue;
        this.resetButton = defaultValue == null ? null : DisplayUtil.createButton(0, 0, 40, 20, (Component)Component.m_237115_((String)"controls.reset"), button -> this.resetValue());
    }

    @Override
    public final void m_6311_(@NotNull GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        super.m_6311_(ctx, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        if (this.isDisabled()) {
            this.title.m_130944_(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.GRAY});
        } else if (!this.isValueValid()) {
            this.title.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
        } else if (!this.value.equals(this.initialValue)) {
            this.title.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        } else {
            this.title.m_130940_(ChatFormatting.RESET);
        }
        Font font = this.client.f_91062_;
        MutableComponent mutableComponent = this.title.m_6881_();
        Objects.requireNonNull(this.client.f_91062_);
        ctx.m_280430_(font, (Component)mutableComponent, rowLeft, rowTop + (height - 9) / 2, 0xFFFFFF);
        int w = width;
        if (this.resetButton != null) {
            w -= this.resetButton.m_5711_() + 2;
            this.resetButton.m_252865_(rowLeft + width - this.resetButton.m_5711_());
            this.resetButton.m_253211_(rowTop + (height - this.resetButton.m_93694_()) / 2);
            this.resetButton.f_93623_ = !this.isValueValid() || !this.isDisabled() && !this.getValue().equals(this.defaultValue);
            this.resetButton.m_88315_(ctx, mouseX, mouseY, deltaTime);
        }
        this.drawValue(ctx, w, height, rowLeft, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void renderTooltip(GuiGraphics ctx, int mouseX, int mouseY) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            int x1 = widget.m_252754_() - 2;
            int y1 = widget.m_252907_();
            int x2 = widget.m_252754_() + widget.m_5711_() + 4;
            int y2 = widget.m_252907_() + widget.m_93694_() + 4;
            if (x1 > mouseX || mouseX > x2 || y1 > mouseY || mouseY > y2) continue;
            return;
        }
        boolean hasDescTl = I18n.m_118936_((String)this.getDescription());
        if (this.id != null || hasDescTl || this.isDisabled() && this.disabledReason != null) {
            String string = this.getTitle().getString();
            ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{Component.m_237113_((String)string).m_7532_()});
            if (hasDescTl) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.getDescription()).m_130940_(ChatFormatting.GRAY), 250));
            }
            if (this.isDisabled() && this.disabledReason != null) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.disabledReason).m_130940_(ChatFormatting.RED), 250));
            }
            if (this.id != null) {
                tooltip.add(Component.m_237113_((String)this.id).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            }
            ctx.m_280245_(this.client.f_91062_, (List)tooltip, mouseX, mouseY);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean match(String filter) {
        boolean match;
        boolean bl = match = super.match(filter) || StringUtils.containsIgnoreCase((CharSequence)this.title.getString(), (CharSequence)filter);
        if (this.id != null) {
            boolean bl2 = match = match || StringUtils.containsIgnoreCase((CharSequence)this.id, (CharSequence)filter);
        }
        if (I18n.m_118936_((String)this.getDescription())) {
            match = match || StringUtils.containsIgnoreCase((CharSequence)I18n.m_118938_((String)this.getDescription(), (Object[])new Object[0]), (CharSequence)filter);
        }
        return match;
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        Button resetButton;
        GuiEventListener element = this.getListener();
        if (element != null) {
            children.add((Object)element);
        }
        if ((resetButton = this.getResetButton()) != null) {
            children.add((Object)resetButton);
        }
    }

    public void save() {
        if (!this.isDisabled()) {
            this.save.accept(this.getValue());
        }
    }

    @Nullable
    public GuiEventListener getListener() {
        return null;
    }

    @Nullable
    public Button getResetButton() {
        return this.resetButton;
    }

    public Component getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getX() {
        return this.x;
    }

    public final T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    protected void resetValue() {
        this.setValue(this.defaultValue);
    }

    public void disable(@Nullable String reason) {
        this.disabledReason = reason;
        this.disabled = true;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    protected abstract void drawValue(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

