/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import mcp.mobius.waila.api.IRegistryFilter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class ExtraBlacklistConfig {
    public final LinkedHashSet<String> blocks = new LinkedHashSet();
    public final LinkedHashSet<String> blockEntityTypes = new LinkedHashSet();
    public final LinkedHashSet<String> entityTypes = new LinkedHashSet();
    @Nullable
    private transient View view;

    public View getView() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public class View {
        public final IRegistryFilter<Block> blockFilter;
        public final IRegistryFilter<BlockEntityType<?>> blockEntityFilter;
        public final IRegistryFilter<EntityType<?>> entityFilter;

        public View() {
            this.blockFilter = IRegistryFilter.of(Registries.f_256747_).parse(ExtraBlacklistConfig.this.blocks).build();
            this.blockEntityFilter = IRegistryFilter.of(Registries.f_256922_).parse(ExtraBlacklistConfig.this.blockEntityTypes).build();
            this.entityFilter = IRegistryFilter.of(Registries.f_256939_).parse(ExtraBlacklistConfig.this.entityTypes).build();
        }
    }

    public static class Adapter
    implements JsonSerializer<ExtraBlacklistConfig>,
    JsonDeserializer<ExtraBlacklistConfig> {
        private final String tagRule;

        public Adapter(ResourceLocation tagId) {
            this.tagRule = "#" + tagId.toString();
        }

        public JsonElement serialize(ExtraBlacklistConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            String[] comments = "The game needs to be restarted for the changes to apply.\n\nOperators:\n@namespace - Filter objects based on their namespace location\n#tag       - Filter objects based on data pack tags\n/regex/    - Filter objects based on regular expression\ndefault    - Filter objects with specific ID\n\nThe %s tag rule can not be removed".formatted(this.tagRule).split("\n");
            JsonArray commentArray = new JsonArray();
            for (String line : comments) {
                commentArray.add(line);
            }
            object.add("_comment", (JsonElement)commentArray);
            object.add("blocks", context.serialize(src.blocks));
            object.add("blockEntityTypes", context.serialize(src.blockEntityTypes));
            object.add("entityTypes", context.serialize(src.entityTypes));
            return object;
        }

        public ExtraBlacklistConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            ExtraBlacklistConfig res = new ExtraBlacklistConfig();
            res.blocks.add(this.tagRule);
            res.blockEntityTypes.add(this.tagRule);
            res.entityTypes.add(this.tagRule);
            this.deserializeEntries(res.blocks, object.getAsJsonArray("blocks"));
            this.deserializeEntries(res.blockEntityTypes, object.getAsJsonArray("blockEntityTypes"));
            this.deserializeEntries(res.entityTypes, object.getAsJsonArray("entityTypes"));
            return res;
        }

        private void deserializeEntries(LinkedHashSet<String> set, JsonArray array) {
            for (JsonElement entry : array) {
                set.add(entry.getAsString());
            }
        }
    }
}

