/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidDescription
implements FluidData.FluidDescription {
    public static final Map<Fluid, FluidData.FluidDescriptor<Fluid>> FLUID_STATIC = new HashMap<Fluid, FluidData.FluidDescriptor<Fluid>>();
    public static final Map<Class<?>, FluidData.FluidDescriptor<Fluid>> FLUID_DYNAMIC = new HashMap();
    public static final Map<Block, FluidData.CauldronDescriptor> CAULDRON_STATIC = new HashMap<Block, FluidData.CauldronDescriptor>();
    public static final Map<Class<?>, FluidData.CauldronDescriptor> CAULDRON_DYNAMIC = new HashMap();
    private static final FluidDescription INSTANCE = new FluidDescription();
    private static final Component UNKNOWN_FLUID_NAME = Component.m_237115_((String)"tooltip.waila.extra.unknown_fluid");
    private static final FluidData.FluidDescriptor<Fluid> UNKNOWN_FLUID_DESC = (ctx, desc) -> {};
    private static final FluidData.CauldronDescriptor NULL_CAULDRON_DESC = state -> null;
    private TextureAtlasSprite sprite;
    private int tint;
    private Component name;

    public static FluidDescription getFluidDesc(FluidData.Entry<?> entry) {
        Object fluid = entry.fluid();
        FluidData.FluidDescriptor<Fluid> descriptor = FLUID_STATIC.get(fluid);
        if (descriptor == null) {
            for (Class<?> clazz = fluid.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                descriptor = FLUID_DYNAMIC.get(clazz);
                if (descriptor == null) continue;
                FLUID_DYNAMIC.put(fluid.getClass(), descriptor);
                break;
            }
        }
        if (descriptor == null) {
            descriptor = UNKNOWN_FLUID_DESC;
            FLUID_STATIC.put((Fluid)fluid, UNKNOWN_FLUID_DESC);
        }
        INSTANCE.sprite(Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49990_.m_49966_()).m_6160_()).tint(-1).name(UNKNOWN_FLUID_NAME);
        descriptor.describeFluid(entry, INSTANCE);
        return INSTANCE;
    }

    @Nullable
    public static FluidData getCauldronFluidData(BlockState state) {
        Block block = state.m_60734_();
        FluidData.CauldronDescriptor getter = CAULDRON_STATIC.get(block);
        if (getter == null) {
            for (Class<?> clazz = block.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                getter = CAULDRON_DYNAMIC.get(clazz);
                if (getter == null) continue;
                CAULDRON_DYNAMIC.put(block.getClass(), getter);
                break;
            }
        }
        if (getter == null) {
            getter = NULL_CAULDRON_DESC;
            CAULDRON_STATIC.put(block, NULL_CAULDRON_DESC);
        }
        return getter.getCauldronFluidData(state);
    }

    public Component name() {
        return this.name;
    }

    public TextureAtlasSprite sprite() {
        return this.sprite;
    }

    public int tint() {
        return this.tint;
    }

    @Override
    public FluidDescription name(Component name) {
        this.name = name;
        return this;
    }

    @Override
    public FluidDescription sprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    @Override
    public FluidDescription tint(int argb) {
        this.tint = argb;
        return this;
    }
}

