/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.EnchantmentDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;

public enum ItemEntityProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static long lastEnchantmentTime;
    private static int enchantmentIndex;
    private static int curseIndex;

    @Override
    @Nullable
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return !config.getBoolean(Options.ITEM_ENTITY) ? EMPTY_ENTITY : null;
    }

    @Override
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        return new ItemComponent(((ItemEntity)accessor.getEntity()).m_32055_());
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        ItemStack stack = ((ItemEntity)accessor.getEntity()).m_32055_();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.m_41786_().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).m_32055_();
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String mod = IModInfo.get(((ItemEntity)accessor.getEntity()).m_32055_()).getName();
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(mod));
        }
    }

    public static void appendBookProperties(ITooltip tooltip, ItemStack stack, IPluginConfig config) {
        if (stack.m_150930_(Items.f_42690_)) {
            EnchantmentDisplayMode mode = (EnchantmentDisplayMode)((Object)config.getEnum(Options.BOOK_ENCHANTMENT_DISPLAY_MODE));
            if (mode == EnchantmentDisplayMode.DISABLED) {
                return;
            }
            if (mode == EnchantmentDisplayMode.CYCLE) {
                int enchantmentTiming = config.getInt(Options.BOOK_ENCHANTMENT_CYCLE_TIMING);
                ListTag enchantmentsTag = EnchantedBookItem.m_41163_((ItemStack)stack);
                long now = System.currentTimeMillis();
                ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
                ArrayList<EnchantmentInstance> curses = new ArrayList<EnchantmentInstance>();
                for (int i = 0; i < enchantmentsTag.size(); ++i) {
                    CompoundTag enchantmentTag = enchantmentsTag.m_128728_(i);
                    Enchantment enchantment2 = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(EnchantmentHelper.m_182446_((CompoundTag)enchantmentTag));
                    if (enchantment2 == null) continue;
                    int level2 = EnchantmentHelper.m_182438_((CompoundTag)enchantmentTag);
                    EnchantmentInstance instance = new EnchantmentInstance(enchantment2, level2);
                    if (enchantment2.m_6589_()) {
                        curses.add(instance);
                        continue;
                    }
                    enchantments.add(instance);
                }
                if (now - lastEnchantmentTime >= (long)enchantmentTiming) {
                    lastEnchantmentTime = now;
                    ++curseIndex;
                    if (++enchantmentIndex > enchantments.size() - 1) {
                        enchantmentIndex = 0;
                    }
                    if (curseIndex > curses.size() - 1) {
                        curseIndex = 0;
                    }
                }
                if (!enchantments.isEmpty()) {
                    EnchantmentInstance instance = (EnchantmentInstance)enchantments.get(enchantmentIndex);
                    tooltip.addLine(instance.f_44947_.m_44700_(instance.f_44948_));
                }
                if (!curses.isEmpty()) {
                    EnchantmentInstance instance = (EnchantmentInstance)curses.get(curseIndex);
                    tooltip.addLine(instance.f_44947_.m_44700_(instance.f_44948_));
                }
            } else {
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                if (mode == EnchantmentDisplayMode.COMBINED) {
                    MutableComponent enchantmentLine = null;
                    MutableComponent curseLine = null;
                    for (Map.Entry entry : enchantments.entrySet()) {
                        Enchantment enchantment3 = (Enchantment)entry.getKey();
                        int level3 = (Integer)entry.getValue();
                        Component name = enchantment3.m_44700_(level3);
                        if (enchantment3.m_6589_()) {
                            if (curseLine == null) {
                                curseLine = Component.m_237119_().m_7220_(name);
                                continue;
                            }
                            curseLine.m_7220_((Component)Component.m_237113_((String)", ")).m_7220_(name);
                            continue;
                        }
                        if (enchantmentLine == null) {
                            enchantmentLine = Component.m_237119_().m_7220_(name);
                            continue;
                        }
                        enchantmentLine.m_7220_((Component)Component.m_237113_((String)", ")).m_7220_(name);
                    }
                    if (enchantmentLine != null) {
                        tooltip.addLine((Component)enchantmentLine);
                    }
                    if (curseLine != null) {
                        tooltip.addLine((Component)curseLine);
                    }
                } else {
                    enchantments.forEach((enchantment, level) -> tooltip.addLine(enchantment.m_44700_(level.intValue())));
                }
            }
        } else if (stack.m_150930_(Items.f_42615_)) {
            if (!config.getBoolean(Options.BOOK_WRITTEN) || !stack.m_41782_()) {
                return;
            }
            CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
            String author = tag.m_128461_("author");
            int generation = WrittenBookItem.m_43473_((ItemStack)stack);
            if (!StringUtil.m_14408_((String)author)) {
                tooltip.addLine((Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{author}));
            }
            tooltip.addLine((Component)Component.m_237115_((String)("book.generation." + generation)));
        }
    }

    static {
        lastEnchantmentTime = 0L;
        enchantmentIndex = 0;
        curseIndex = 0;
    }
}

