/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.registry.Register;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public enum Registrar implements IRegistrar
{
    INSTANCE;

    private static final Log LOG;
    public final Register<IBlockComponentProvider> blockOverride = new Register();
    public final Register<IBlockComponentProvider> blockIcon = new Register();
    public final Register<IDataProvider<BlockEntity>> blockData = new Register();
    public final Map<TooltipPosition, Register<IBlockComponentProvider>> blockComponent = (Map)Util.m_137469_(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEntityComponentProvider> entityOverride = new Register();
    public final Register<IEntityComponentProvider> entityIcon = new Register();
    public final Register<IDataProvider<Entity>> entityData = new Register();
    public final Map<TooltipPosition, Register<IEntityComponentProvider>> entityComponent = (Map)Util.m_137469_(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEventListener> eventListeners = (Register)Util.m_137469_(new Register(), Register::reversed);
    public final BlacklistConfig blacklist = new BlacklistConfig();
    public final Map<ResourceLocation, IntFormat> intConfigFormats = new HashMap<ResourceLocation, IntFormat>();
    public final BiMap<ResourceLocation, ThemeType<?>> themeTypes = HashBiMap.create();
    public final Map<Class<? extends IData>, ResourceLocation> dataType2Id = new HashMap<Class<? extends IData>, ResourceLocation>();
    public final Map<ResourceLocation, IData.Serializer<?>> dataId2Serializer = new HashMap();
    private int pickerPriority = Integer.MAX_VALUE;
    public IObjectPicker picker = null;
    private boolean locked = false;

    private <T> void addConfig(ResourceLocation key, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged, ConfigEntry.Type<T> type) {
        this.assertLock();
        PluginConfig.addConfig(type.create(key, defaultValue, clientOnlyValue, serverRequired, merged));
    }

    @SafeVarargs
    private <T> void addBlacklist(Set<String> set, Registry<T> registry, T ... values) {
        this.assertLock();
        for (T value : values) {
            set.add(Objects.requireNonNull(registry.m_7981_(value)).toString());
        }
    }

    @Override
    public void addConfig(ResourceLocation key, boolean defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addConfig(ResourceLocation key, int defaultValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addConfig(ResourceLocation key, double defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addConfig(ResourceLocation key, String defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addConfig(ResourceLocation key, T defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.ENUM);
    }

    @Override
    public void addConfig(ResourceLocation key, Path path) {
        this.addConfig(key, path, path, false, false, ConfigEntry.PATH);
    }

    @Override
    public void addFeatureConfig(ResourceLocation key, boolean clientOnly) {
        this.addConfig(key, true, clientOnly, !clientOnly, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, boolean defaultValue, boolean clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, int defaultValue, int clientOnlyValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, double defaultValue, double clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, String defaultValue, String clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addSyncedConfig(ResourceLocation key, T defaultValue, T clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.ENUM);
    }

    @Override
    public void addEventListener(IEventListener listener, int priority) {
        this.assertLock();
        this.eventListeners.add(Object.class, listener, priority);
    }

    @Override
    public void addBlacklist(Block ... blocks) {
        this.addBlacklist((Set<String>)this.blacklist.blocks, (Registry)BuiltInRegistries.f_256975_, (T[])blocks);
    }

    @Override
    public void addBlacklist(BlockEntityType<?> ... blockEntityTypes) {
        this.addBlacklist(this.blacklist.blockEntityTypes, BuiltInRegistries.f_257049_, blockEntityTypes);
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, BE extends BlockEntity> void addBlockData(IDataProvider<BE> provider, Class<T> clazz, int priority) {
        this.assertLock();
        this.assertPriority(priority);
        this.blockData.add(clazz, provider, priority);
    }

    @Override
    public void addBlacklist(EntityType<?> ... entityTypes) {
        this.addBlacklist((Set<String>)this.blacklist.entityTypes, (Registry)BuiltInRegistries.f_256780_, (T[])entityTypes);
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, E extends Entity> void addEntityData(IDataProvider<E> provider, Class<T> clazz, int priority) {
        this.assertLock();
        this.assertPriority(priority);
        this.entityData.add(clazz, provider, priority);
    }

    @Override
    public <T extends IData> void addDataType(ResourceLocation id, Class<T> type, IData.Serializer<T> serializer) {
        this.assertLock();
        Preconditions.checkArgument((!this.dataId2Serializer.containsKey(id) ? 1 : 0) != 0, (String)"Data type with id %s already present", (Object)id);
        this.dataType2Id.put(type, id);
        this.dataId2Serializer.put(id, serializer);
    }

    @Override
    public <T extends ITheme> void addThemeType(ResourceLocation id, IThemeType<T> type) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            ThemeType casted = (ThemeType)TypeUtil.uncheckedCast(type);
            this.themeTypes.put((Object)id, (Object)casted);
        }
    }

    @Override
    public void replacePicker(IObjectPicker picker, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            if (priority <= this.pickerPriority) {
                this.picker = picker;
                this.pickerPriority = priority;
            }
        }
    }

    public void lock() {
        this.locked = true;
        if (Waila.CLIENT_SIDE) {
            Preconditions.checkState((this.picker != null ? 1 : 0) != 0, (Object)"No object picker registered");
            LOG.info("Using {} as the object picker", this.picker.getClass().getName());
        }
        int[] hash = new int[]{0, 0, 0};
        hash[0] = this.blacklist.blocks.hashCode();
        hash[1] = this.blacklist.blockEntityTypes.hashCode();
        hash[2] = this.blacklist.entityTypes.hashCode();
        BlacklistConfig userBlacklist = Waila.BLACKLIST_CONFIG.get();
        if (!Arrays.equals(userBlacklist.pluginHash, hash)) {
            if (!Arrays.equals(userBlacklist.pluginHash, new int[]{0, 0, 0})) {
                Waila.BLACKLIST_CONFIG.backup("plugin hash mismatch");
            }
            BlacklistConfig newBlacklist = Waila.BLACKLIST_CONFIG.get();
            newBlacklist.pluginHash = hash;
            newBlacklist.blocks.addAll(this.blacklist.blocks);
            newBlacklist.blockEntityTypes.addAll(this.blacklist.blockEntityTypes);
            newBlacklist.entityTypes.addAll(this.blacklist.entityTypes);
        }
        Waila.BLACKLIST_CONFIG.save();
    }

    private void assertLock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }

    static {
        LOG = Log.create();
    }
}

