/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EnergyCellBlock
extends PortalGroupBlock {
    public static final IntegerProperty ENERGY_LEVEL = IntegerProperty.m_61631_((String)"energy_level", (int)0, (int)15);
    private final EnergyCellType type;

    public EnergyCellBlock(EnergyCellType type) {
        super(type::getBlockEntityType);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ENERGY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        CompoundTag tag;
        info.accept((Component)TextComponents.translation((String)"wormhole.energy_cell.info").color(ChatFormatting.AQUA).get());
        CompoundTag compoundTag = tag = stack.m_41784_().m_128441_("tileData") ? stack.m_41784_().m_128469_("tileData") : null;
        int energy = this.type == EnergyCellType.CREATIVE ? this.type.getCapacity() : (tag == null || tag.m_128456_() || !tag.m_128441_("energy") ? 0 : tag.m_128451_("energy"));
        int capacity = this.type.getCapacity();
        if (capacity > 0) {
            info.accept((Component)TextComponents.string((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)capacity)).color(ChatFormatting.YELLOW).get());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENERGY_LEVEL});
    }
}

