/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.GeneratorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CoalGeneratorBlockEntity
extends GeneratorBlockEntity
implements IItemHandlerModifiable {
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this);
    private int burnTime = 0;
    private int totalBurnTime = 0;
    private ItemStack stack = ItemStack.f_41583_;

    public CoalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(Wormhole.coal_generator_tile, pos, state, WormholeConfig.coalGeneratorCapacity.get(), WormholeConfig.coalGeneratorRange.get(), WormholeConfig.coalGeneratorPower.get() * 2);
    }

    @Override
    public void update() {
        super.update();
        if (this.energy < this.energyCapacity) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.energy += WormholeConfig.coalGeneratorPower.get().intValue();
                if (this.energy > this.energyCapacity) {
                    this.energy = this.energyCapacity;
                }
                if (this.burnTime == 0) {
                    this.totalBurnTime = 0;
                    this.burnItem();
                }
                this.dataChanged();
            } else {
                this.burnItem();
            }
        }
    }

    private void burnItem() {
        int burnTime;
        int n = burnTime = this.stack.m_41619_() ? 0 : ForgeHooks.getBurnTime((ItemStack)this.stack, (RecipeType)RecipeType.f_44108_);
        if (burnTime > 0) {
            this.burnTime = this.totalBurnTime = burnTime;
            this.stack.m_41774_(1);
            this.dataChanged();
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        boolean lit = (Boolean)this.m_58900_().m_61143_((Property)CoalGeneratorBlock.LIT);
        if (lit != this.burnTime > 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(!lit)));
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag data = super.writeData();
        data.m_128405_("burnTime", this.burnTime);
        data.m_128405_("totalBurnTime", this.totalBurnTime);
        data.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        return data;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.burnTime = tag.m_128441_("burnTime") ? tag.m_128451_("burnTime") : 0;
        this.totalBurnTime = tag.m_128441_("totalBurnTime") ? tag.m_128451_("totalBurnTime") : 0;
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
    }

    public float getProgress() {
        return this.totalBurnTime == 0 ? 0.0f : (float)this.burnTime / (float)this.totalBurnTime;
    }

    public int getSlots() {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            this.stack = stack.m_41777_();
        }
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || !this.stack.m_41619_() && !ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)stack)) {
            return stack;
        }
        int count = Math.min(stack.m_41741_() - this.stack.m_41613_(), stack.m_41613_());
        if (!simulate) {
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(this.stack.m_41613_() + count);
            this.stack = newStack;
        }
        ItemStack result = stack.m_41777_();
        result.m_41774_(count);
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.stack.m_41619_() ? 64 : this.stack.m_41741_();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Math.floor((double)ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) / 2.5) > 0.0;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }
}

