/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int BLOCKS_PER_TICK = 5;
    protected int energy;
    protected final int energyCapacity;
    private final int energyRange;
    private final int energyTransferLimit;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this);
    private final Set<BlockPos> portalBlocks = new LinkedHashSet<BlockPos>();
    private final HashMap<BlockPos, Direction> energyBlocks = new HashMap();
    private int searchX;
    private int searchY;
    private int searchZ;

    public GeneratorBlockEntity(BaseBlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int energyCapacity, int energyRange, int energyTransferLimit) {
        super(blockEntityType, pos, state);
        this.energyCapacity = energyCapacity;
        this.energyRange = energyRange;
        this.energyTransferLimit = energyTransferLimit;
        this.searchY = this.searchZ = -energyRange;
        this.searchX = this.searchZ;
    }

    public void update() {
        if (!this.f_58857_.f_46443_) {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = this.f_58858_.m_7918_(this.searchX, this.searchY, this.searchZ);
                if (!pos.equals((Object)this.f_58858_)) {
                    BlockEntity entity = this.f_58857_.m_7702_(pos);
                    if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                        if (!this.portalBlocks.contains(pos) || this.energyBlocks.containsKey(pos)) {
                            this.portalBlocks.add(pos);
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                    } else {
                        boolean bl = false;
                        Direction inputSide = Direction.UP;
                        if (entity != null) {
                            for (Direction side : Direction.values()) {
                                LazyOptional optional = entity.getCapability(ForgeCapabilities.ENERGY, side);
                                if (!optional.map(IEnergyStorage::canReceive).orElse(false).booleanValue()) continue;
                                bl = true;
                                inputSide = side;
                                break;
                            }
                        }
                        if (bl && this.energyBlocks.get(pos) != inputSide) {
                            this.energyBlocks.put(pos, inputSide);
                            this.dataChanged();
                        } else if (!bl && this.energyBlocks.containsKey(pos)) {
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                        if (this.portalBlocks.contains(pos)) {
                            this.portalBlocks.remove(pos);
                            this.dataChanged();
                        }
                    }
                }
                ++this.searchX;
                if (this.searchX <= this.energyRange) continue;
                this.searchX = -this.energyRange;
                ++this.searchZ;
                if (this.searchZ <= this.energyRange) continue;
                this.searchZ = -this.energyRange;
                ++this.searchY;
                if (this.searchY <= this.energyRange) continue;
                this.searchY = -this.energyRange;
            }
            if (this.energy <= 0) {
                return;
            }
            int toTransfer = Math.min(this.energyTransferLimit, this.energy);
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos blockPos : this.portalBlocks) {
                BlockEntity entity = this.f_58857_.m_7702_(blockPos);
                if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                    PortalGroup group = ((IPortalGroupEntity)entity).getGroup();
                    int transferred = group.receiveEnergy(toTransfer, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(blockPos);
            }
            if (!toRemove.isEmpty()) {
                this.portalBlocks.removeAll(toRemove);
                toRemove.clear();
                this.dataChanged();
            }
            for (Map.Entry entry : this.energyBlocks.entrySet()) {
                LazyOptional optional;
                BlockPos pos = (BlockPos)entry.getKey();
                BlockEntity entity = this.f_58857_.m_7702_(pos);
                if (entity != null && (optional = entity.getCapability(ForgeCapabilities.ENERGY, (Direction)entry.getValue())).isPresent()) {
                    int max = toTransfer;
                    int transferred = optional.map(storage -> storage.receiveEnergy(max, false)).orElse(0);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(pos);
            }
            if (!toRemove.isEmpty()) {
                toRemove.forEach(this.energyBlocks::remove);
                this.dataChanged();
            }
        }
    }

    public Set<BlockPos> getChargingPortalBlocks() {
        return this.portalBlocks;
    }

    public Set<BlockPos> getChargingEnergyBlocks() {
        return this.energyBlocks.keySet();
    }

    protected CompoundTag writeData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("energy", this.energy);
        data.m_128405_("searchX", this.searchX);
        data.m_128405_("searchY", this.searchY);
        data.m_128405_("searchZ", this.searchZ);
        data.m_128428_("portalBlocks", this.portalBlocks.stream().map(BlockPos::m_121878_).collect(Collectors.toList()));
        int[] energyBlocks = new int[this.energyBlocks.size() * 4];
        int index = 0;
        for (Map.Entry<BlockPos, Direction> entry : this.energyBlocks.entrySet()) {
            energyBlocks[index++] = entry.getKey().m_123341_();
            energyBlocks[index++] = entry.getKey().m_123342_();
            energyBlocks[index++] = entry.getKey().m_123343_();
            energyBlocks[index++] = entry.getValue().m_122411_();
        }
        data.m_128385_("energyBlocks", energyBlocks);
        return data;
    }

    protected void readData(CompoundTag tag) {
        this.energy = tag.m_128441_("energy") ? tag.m_128451_("energy") : 0;
        this.searchX = tag.m_128441_("searchX") ? Math.min(Math.max(tag.m_128451_("searchX"), -this.energyRange), this.energyRange) : 0;
        this.searchY = tag.m_128441_("searchY") ? Math.min(Math.max(tag.m_128451_("searchY"), -this.energyRange), this.energyRange) : 0;
        this.searchZ = tag.m_128441_("searchZ") ? Math.min(Math.max(tag.m_128451_("searchZ"), -this.energyRange), this.energyRange) : 0;
        this.portalBlocks.clear();
        if (tag.m_128425_("portalBlocks", 12)) {
            Arrays.stream(tag.m_128467_("portalBlocks")).mapToObj(BlockPos::m_122022_).forEach(this.portalBlocks::add);
        }
        this.energyBlocks.clear();
        if (tag.m_128425_("energyBlocks", 11)) {
            int[] energyBlocks = tag.m_128465_("energyBlocks");
            int i = 0;
            while (i < energyBlocks.length / 4 * 4) {
                this.energyBlocks.put(new BlockPos(energyBlocks[i++], energyBlocks[i++], energyBlocks[i++]), Direction.m_122376_((int)energyBlocks[i++]));
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(Math.min(this.energy, this.energyTransferLimit), maxExtract);
        if (extracted > 0 && !simulate) {
            this.energy -= extracted;
            this.dataChanged();
        }
        return Math.max(extracted, 0);
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }
}

