/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.supermartijn642.core.TextComponents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PortalTarget {
    public static final int MAX_NAME_LENGTH = 10;
    public final ResourceKey<Level> dimension;
    public final int x;
    public final int y;
    public final int z;
    public final float yaw;
    public String name;
    public DyeColor color = null;
    public Component dimensionDisplayName;

    public PortalTarget(ResourceKey<Level> dimension, int x, int y, int z, float yaw, String name) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.name = name;
        this.dimensionDisplayName = TextComponents.dimension(dimension).get();
    }

    public PortalTarget(Level level, BlockPos pos, float yaw, String name) {
        this((ResourceKey<Level>)level.m_46472_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), yaw, name);
    }

    public PortalTarget(CompoundTag tag) {
        this((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension"))), tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"), tag.m_128457_("yaw"), tag.m_128441_("name") ? tag.m_128461_("name") : "Target Destination");
        this.color = tag.m_128441_("color") ? DyeColor.m_41053_((int)tag.m_128451_("color")) : null;
    }

    public static PortalTarget read(CompoundTag tag) {
        return new PortalTarget(tag);
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", this.dimension.m_135782_().toString());
        tag.m_128405_("x", this.x);
        tag.m_128405_("y", this.y);
        tag.m_128405_("z", this.z);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128359_("name", this.name);
        if (this.color != null) {
            tag.m_128405_("color", this.color.m_41060_());
        }
        return tag;
    }

    public Optional<Level> getLevel(MinecraftServer server) {
        return Optional.ofNullable(server.m_129880_(this.dimension));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vec3 getCenteredPos() {
        return new Vec3((double)this.x + 0.5, (double)this.y + 0.2, (double)this.z + 0.5);
    }

    public Component getDimensionDisplayName() {
        return this.dimensionDisplayName;
    }
}

