/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.graveteleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="teleportcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GraveCommand {
    public GraveCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"grave").requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_()) {
                if (((Boolean)PreferencesConfig.allowGraveCommand.get()).booleanValue()) {
                    this.teleportToGrave(player);
                } else {
                    player.m_213846_((Component)Component.m_237119_().m_130946_("This grave command is currently disabled"));
                    SoundManager.playSound(player, SoundEvents.f_11983_);
                }
            }
            return 0;
        }));
    }

    private void teleportToGrave(ServerPlayer player) {
        if (!(player.getPersistentData().m_128441_("teleportcraft:graveXCoord") && player.getPersistentData().m_128441_("teleportcraft:graveYCoord") && player.getPersistentData().m_128441_("teleportcraft:graveZCoord") && player.getPersistentData().m_128441_("teleportcraft:graveWorld"))) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("There is no death point to teleport to"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        int requiredXP = (Integer)PreferencesConfig.xpToUseGraveCommand.get();
        if (player.f_36078_ < requiredXP) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("You need at least " + requiredXP + " experience levels to do this"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        String worldName = player.getPersistentData().m_128461_("teleportcraft:graveWorld");
        double x = player.getPersistentData().m_128459_("teleportcraft:graveXCoord");
        double y = player.getPersistentData().m_128459_("teleportcraft:graveYCoord");
        double z = player.getPersistentData().m_128459_("teleportcraft:graveZCoord");
        for (ServerLevel level : Objects.requireNonNull(player.m_20194_()).m_129785_()) {
            if (!level.m_46472_().m_135782_().toString().equals(worldName)) continue;
            EntityTeleportEvent.TeleportCommand event = new EntityTeleportEvent.TeleportCommand((Entity)player, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            player.m_213846_((Component)Component.m_237119_().m_130946_("Teleporting you to your last death point ..."));
            player.m_8999_(level, x, y, z, player.m_146908_(), player.m_146909_());
            player.m_9174_(player.f_36078_ - requiredXP);
            SoundManager.playSound(player, SoundEvents.f_11852_);
            return;
        }
        player.m_213846_((Component)Component.m_237119_().m_130946_("Failed to teleport to death point because the world was not found"));
        SoundManager.playSound(player, SoundEvents.f_11983_);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            String graveWorld = player.m_284548_().m_46472_().m_135782_().toString();
            player.getPersistentData().m_128347_("teleportcraft:graveXCoord", player.m_20185_());
            player.getPersistentData().m_128347_("teleportcraft:graveYCoord", player.m_20186_());
            player.getPersistentData().m_128347_("teleportcraft:graveZCoord", player.m_20189_());
            player.getPersistentData().m_128359_("teleportcraft:graveWorld", graveWorld);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        double x = event.getOriginal().getPersistentData().m_128459_("teleportcraft:graveXCoord");
        double y = event.getOriginal().getPersistentData().m_128459_("teleportcraft:graveYCoord");
        double z = event.getOriginal().getPersistentData().m_128459_("teleportcraft:graveZCoord");
        String worldName = event.getOriginal().getPersistentData().m_128461_("teleportcraft:graveWorld");
        Player player = event.getEntity();
        player.getPersistentData().m_128347_("teleportcraft:graveXCoord", x);
        player.getPersistentData().m_128347_("teleportcraft:graveYCoord", y);
        player.getPersistentData().m_128347_("teleportcraft:graveZCoord", z);
        player.getPersistentData().m_128359_("teleportcraft:graveWorld", worldName);
    }
}

