/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.hometeleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class HomeCommand {
    public HomeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_()) {
                if (((Boolean)PreferencesConfig.allowHomeCommands.get()).booleanValue()) {
                    this.teleportHome(player);
                } else {
                    player.m_213846_((Component)Component.m_237119_().m_130946_("This home command is currently disabled"));
                    SoundManager.playSound(player, SoundEvents.f_11983_);
                }
            }
            return 0;
        }));
    }

    private void teleportHome(ServerPlayer player) {
        if (!(player.getPersistentData().m_128441_("teleportcraft:homeXCoord") && player.getPersistentData().m_128441_("teleportcraft:homeYCoord") && player.getPersistentData().m_128441_("teleportcraft:homeZCoord") && player.getPersistentData().m_128441_("teleportcraft:homeWorld"))) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("You have not set a home"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        int requiredXP = (Integer)PreferencesConfig.xpToUseHomeCommand.get();
        if (player.f_36078_ < requiredXP) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("You need at least " + requiredXP + " experience levels to do this"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        player.m_213846_((Component)Component.m_237119_().m_130946_("You will now be teleported home ..."));
        CompoundTag data = player.getPersistentData();
        double x = data.m_128459_("teleportcraft:homeXCoord");
        double y = data.m_128459_("teleportcraft:homeYCoord");
        double z = data.m_128459_("teleportcraft:homeZCoord");
        String worldName = data.m_128461_("teleportcraft:homeWorld");
        for (ServerLevel level : Objects.requireNonNull(player.m_20194_()).m_129785_()) {
            if (!level.m_46472_().m_135782_().toString().equals(worldName)) continue;
            EntityTeleportEvent.TeleportCommand event = new EntityTeleportEvent.TeleportCommand((Entity)player, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            player.m_8999_(level, x, y, z, player.m_146908_(), player.m_146909_());
            player.m_9174_(player.f_36078_ - requiredXP);
            SoundManager.playSound(player, SoundEvents.f_11852_);
            return;
        }
        player.m_213846_((Component)Component.m_237119_().m_130946_("Failed to teleport home because the home world was not found"));
        SoundManager.playSound(player, SoundEvents.f_11983_);
    }
}

