/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.init;

import com.github.L_Ender.cataclysm.capabilities.Bloom_Stone_PauldronsCapability;
import com.github.L_Ender.cataclysm.capabilities.ChargeCapability;
import com.github.L_Ender.cataclysm.capabilities.Gone_With_SandstormCapability;
import com.github.L_Ender.cataclysm.capabilities.HoldAttackCapability;
import com.github.L_Ender.cataclysm.capabilities.HookCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModCapabilities {
    public static final Capability<HookCapability.IHookCapability> HOOK_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<HookCapability.IHookCapability>(){});
    public static final Capability<ChargeCapability.IChargeCapability> CHARGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChargeCapability.IChargeCapability>(){});
    public static final Capability<Bloom_Stone_PauldronsCapability.IBloom_Stone_PauldronsCapability> BLOOM_STONE_PAULDRONS_CAPABILITY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Bloom_Stone_PauldronsCapability.IBloom_Stone_PauldronsCapability>(){});
    public static final Capability<Gone_With_SandstormCapability.IGone_With_SandstormCapability> GONE_WITH_SANDSTORM_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Gone_With_SandstormCapability.IGone_With_SandstormCapability>(){});
    public static final Capability<HoldAttackCapability.HoldAttackCapabilityImp> HOLD_ATTACK_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<HoldAttackCapability.HoldAttackCapabilityImp>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(HookCapability.HookCapabilityImp.class);
        event.register(ChargeCapability.ChargeCapabilityImp.class);
        event.register(Bloom_Stone_PauldronsCapability.Bloom_Stone_PauldronsCapabilityImp.class);
        event.register(Gone_With_SandstormCapability.Gone_With_SandstormCapabilityImp.class);
        event.register(HoldAttackCapability.HoldAttackCapabilityImp.class);
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> e) {
        Object object = e.getObject();
        if (object instanceof LivingEntity) {
            final LivingEntity living = (LivingEntity)object;
            e.addCapability(HookCapability.ID, (ICapabilityProvider)new HookCapability.HookCapabilityImp.HookProvider());
            e.addCapability(ChargeCapability.ID, (ICapabilityProvider)new ChargeCapability.ChargeCapabilityImp.ChargeProvider());
            e.addCapability(HoldAttackCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                private final LazyOptional<HoldAttackCapability.IHoldAttackCapability> inst = LazyOptional.of(() -> {
                    HoldAttackCapability.HoldAttackCapabilityImp cap = new HoldAttackCapability.HoldAttackCapabilityImp();
                    cap.setEntity(living);
                    return cap;
                });

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((HoldAttackCapability.IHoldAttackCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((HoldAttackCapability.IHoldAttackCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return HOLD_ATTACK_CAPABILITY.orEmpty(cap, this.inst.cast());
                }
            });
            Object object2 = e.getObject();
            if (object2 instanceof Player) {
                Player player = (Player)object2;
                e.addCapability(Bloom_Stone_PauldronsCapability.ID, (ICapabilityProvider)new Bloom_Stone_PauldronsCapability.Bloom_Stone_PauldronsCapabilityImp.Bloom_Stone_PauldronsProvider());
                Gone_With_SandstormCapability.Gone_With_SandstormCapabilityImp spellHolder = new Gone_With_SandstormCapability.Gone_With_SandstormCapabilityImp((LivingEntity)player);
                ModCapabilities.attachCapability(e, spellHolder, GONE_WITH_SANDSTORM_CAPABILITY, "sandstorm_cap");
            }
        }
    }

    @javax.annotation.Nullable
    public static <T> T getCapability(Entity entity, Capability<T> capability) {
        if (entity == null) {
            return null;
        }
        if (!entity.m_6084_()) {
            return null;
        }
        return (T)(entity.getCapability(capability).isPresent() ? entity.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    private static <T extends Tag, C extends INBTSerializable<T>> void attachCapability(AttachCapabilitiesEvent<?> event, final C capData, final Capability<C> capability, String name) {
        final LazyOptional optional = LazyOptional.of(() -> capData);
        ICapabilitySerializable provider = new ICapabilitySerializable<T>(){

            public <S> LazyOptional<S> getCapability(Capability<S> cap, Direction side) {
                if (cap == capability) {
                    return optional.cast();
                }
                return LazyOptional.empty();
            }

            public T serializeNBT() {
                return capData.serializeNBT();
            }

            public void deserializeNBT(T tag) {
                capData.deserializeNBT(tag);
            }
        };
        event.addCapability(new ResourceLocation("cataclysm", name), (ICapabilityProvider)provider);
    }
}

