/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.WorldMap;
import xaero.map.common.config.CommonConfig;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.level.LevelMapPropertiesIO;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayer) {
            Player newPlayer = event.getEntity();
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get((ServerPlayer)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            WorldMap.messageHandler.sendToPlayer((ServerPlayer)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayer player) {
        WorldMap.messageHandler.sendToPlayer(player, new HandshakePacket());
        CommonConfig config = WorldMap.commonConfig;
        WorldMap.messageHandler.sendToPlayer(player, new ClientboundRulesPacket(config.allowCaveModeOnServer, config.allowNetherCaveModeOnServer));
        Path propertiesPath = player.m_9236_().m_7654_().m_129843_(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.m_20194_());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            WorldMap.messageHandler.sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"gui.xaero_wm_error_loading_properties"));
        }
    }
}

