/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.integration.BumblezoneCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SugarBlock
extends ConcretePowderBlock {
    public SugarBlock(BlockBehaviour.Properties properties) {
        super(Blocks.f_49990_, properties);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlock) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_213897_(blockState, serverLevel, pos, level.f_46441_);
        }
        if (this.isWater(blockState2)) {
            // empty if block
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        level.m_186460_(currentPos, (Block)this, this.m_7198_());
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.touchesLiquid((BlockGetter)level, pos)) {
            level.m_7696_(pos, state.m_60734_(), 1, 0);
        } else {
            super.m_213897_(state, level, pos, random);
        }
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.f_46443_) {
                this.spawnDissolveParticles(level, pos);
            }
            if (this.shouldTurnToWater(level, pos)) {
                SugarBlock.turnIntoWater(level, pos);
            } else {
                level.m_7471_(pos, false);
            }
            return true;
        }
        return super.m_8133_(state, level, pos, id, param);
    }

    private static void turnIntoWater(Level level, BlockPos pos) {
        if (CompatHandler.BUMBLEZONE) {
            BumblezoneCompat.turnToSugarWater(level, pos);
        } else {
            level.m_46597_(pos, Blocks.f_49990_.m_49966_());
        }
    }

    private boolean shouldTurnToWater(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        int count = 0;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN) continue;
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            BlockState s = level.m_8055_((BlockPos)mutableBlockPos);
            if (this.isWater(s) && (direction == Direction.UP || s.m_60819_().m_76170_())) {
                ++count;
            }
            if (count < 2) continue;
            return true;
        }
        return false;
    }

    private boolean touchesLiquid(BlockGetter level, BlockPos pos) {
        boolean bl = false;
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
        if (this.isWater(blockState)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (!this.isWater(blockState) || blockState.m_60783_(level, pos, direction.m_122424_())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isWater(BlockState state) {
        return state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public void spawnDissolveParticles(Level level, BlockPos pos) {
        boolean d = false;
        boolean e = false;
        boolean f = false;
        int amount = 4;
        for (int ax = 0; ax < amount; ++ax) {
            for (int ay = 0; ay < amount; ++ay) {
                for (int az = 0; az < amount; ++az) {
                    double s = ((double)ax + 0.5) / (double)amount;
                    double t = ((double)ay + 0.5) / (double)amount;
                    double u = ((double)az + 0.5) / (double)amount;
                    double px = s + (double)d;
                    double py = t + (double)e;
                    double pz = u + (double)f;
                    level.m_7106_((ParticleOptions)ModParticles.SUGAR_PARTICLE.get(), (double)pos.m_123341_() + px, (double)pos.m_123342_() + py, (double)pos.m_123343_() + pz, s - 0.5, 0.0, u - 0.5);
                }
            }
        }
    }

    public int m_6248_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_284242_((BlockGetter)level, (BlockPos)pos).f_283871_;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            this.spawnDissolveParticles(level, pos);
        }
        SoundType soundtype = state.m_60827_();
        level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
    }
}

