/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapTrade;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventurerMapsHandler
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AdventurerMapTrade.class, (json, typeOfT, context) -> (AdventurerMapTrade)AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e))).create();
    public static final PreparableReloadListener RELOAD_INSTANCE = new AdventurerMapsHandler();
    public static final int SEARCH_RADIUS = 150;
    private static final List<AdventurerMapTrade> CUSTOM_MAPS_TRADES = new ArrayList<AdventurerMapTrade>();

    public AdventurerMapsHandler() {
        super(GSON, "structure_maps");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        CUSTOM_MAPS_TRADES.clear();
        jsons.forEach((key, json) -> {
            DataResult v = AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            AdventurerMapTrade data = (AdventurerMapTrade)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e));
            CUSTOM_MAPS_TRADES.add(data);
        });
        if (CUSTOM_MAPS_TRADES.size() != 0) {
            Supplementaries.LOGGER.info("Loaded  " + CUSTOM_MAPS_TRADES.size() + " structure maps trades");
        }
    }

    public static void addTradesCallback() {
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)1, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 1));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)2, itemListings -> {
            if (CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS.get().booleanValue()) {
                itemListings.add(new RandomAdventureMapTrade());
            }
            AdventurerMapsHandler.maybeAddCustomMap(itemListings, 2);
        });
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)3, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 3));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)4, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 4));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)5, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 5));
    }

    private static void maybeAddCustomMap(List<VillagerTrades.ItemListing> listings, int level) {
        for (AdventurerMapTrade data : CUSTOM_MAPS_TRADES) {
            if (level != data.villagerLevel()) continue;
            listings.add(data);
        }
    }

    public static ItemStack createMapOrQuill(ServerLevel serverLevel, BlockPos pos, @Nullable HolderSet<Structure> targets, int radius, boolean skipKnown, int zoom, @Nullable ResourceLocation mapMarker, @Nullable String name, int color) {
        StructureLocator.LocatedStruct found;
        if (CompatHandler.QUARK && CommonConfigs.Tweaks.QUARK_QUILL.get().booleanValue()) {
            ItemStack item = QuarkCompat.makeAdventurerQuill(serverLevel, targets, radius, skipKnown, zoom, null, name, color);
            item.m_41714_((Component)Component.m_237115_((String)name));
            return item;
        }
        if (!serverLevel.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return ItemStack.f_41583_;
        }
        if (targets == null && (targets = (HolderSet)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203431_(ModTags.ADVENTURE_MAP_DESTINATIONS).orElse(null)) == null) {
            targets = HolderSet.m_205809_((Holder[])new Holder[0]);
        }
        if ((found = StructureLocator.findNearestRandomMapFeature(serverLevel, targets, pos, radius, skipKnown)) != null) {
            BlockPos toPos = found.pos();
            return AdventurerMapsHandler.createStructureMap(serverLevel, toPos, found.structure(), zoom, mapMarker, name, color);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack createStructureMap(ServerLevel level, BlockPos pos, Holder<Structure> structure, int zoom, @Nullable ResourceLocation decoration, @Nullable String name, int color) {
        ItemStack stack = MapItem.m_42886_((Level)level, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)((byte)zoom), (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)stack);
        if (decoration == null) {
            MapDecorationType type = MapDataRegistry.getAssociatedType(structure);
            decoration = Utils.getID((MapDecorationType)type);
            if (color == 0) {
                color = type.getDefaultMapColor();
            }
        }
        MapHelper.addDecorationToMap((ItemStack)stack, (BlockPos)pos, (ResourceLocation)decoration, (int)color);
        if (name != null) {
            stack.m_41714_((Component)Component.m_237115_((String)name));
        }
        return stack;
    }

    public static ItemStack createCustomMapForTrade(Level level, BlockPos pos, ResourceLocation structureName, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TagKey destination = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureName);
            String name = mapName == null ? "filled_map." + structureName.m_135815_().toLowerCase(Locale.ROOT) : mapName;
            HolderSet.Named targets = serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203431_(destination).orElse(null);
            if (targets != null) {
                return AdventurerMapsHandler.createMapOrQuill(serverLevel, pos, (HolderSet<Structure>)targets, 150, true, 2, mapMarker, name, mapColor);
            }
        }
        return ItemStack.f_41583_;
    }

    private static class RandomAdventureMapTrade
    implements VillagerTrades.ItemListing {
        private RandomAdventureMapTrade() {
        }

        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            int maxPrice = 11;
            int minPrice = 6;
            int price = random.m_188503_(maxPrice - minPrice + 1) + minPrice;
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack itemstack = AdventurerMapsHandler.createMapOrQuill(serverLevel, entity.m_20183_(), null, 150, true, 2, null, "filled_map.adventure", 7869722);
                int uses = CommonConfigs.Tweaks.QUILL_MAX_TRADES.get();
                int x = 6;
                int xp = (int)((float)(x * 12) / (float)uses);
                int cost = (int)((double)price * CommonConfigs.Tweaks.QUILL_TRADE_PRICE_MULT.get());
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, cost), new ItemStack((ItemLike)Items.f_42522_), itemstack, uses, xp, 0.2f);
            }
            return null;
        }
    }
}

