/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import pro.mikey.xray.Configuration;
import pro.mikey.xray.XRay;
import pro.mikey.xray.keybinding.KeyBindings;
import pro.mikey.xray.store.BlockStore;
import pro.mikey.xray.store.DiscoveryStorage;
import pro.mikey.xray.store.GameBlockStore;
import pro.mikey.xray.utils.BlockData;
import pro.mikey.xray.xray.Controller;
import pro.mikey.xray.xray.Events;

public class ClientController {
    public static GameBlockStore gameBlockStore = new GameBlockStore();
    public static DiscoveryStorage blockStore = new DiscoveryStorage();

    public static void setup() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientController::onSetup);
        eventBus.addListener(ClientController::onLoadComplete);
        eventBus.addListener(KeyBindings::registerKeyBinding);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC);
        MinecraftForge.EVENT_BUS.register(KeyBindings.class);
        MinecraftForge.EVENT_BUS.addListener(ClientController::onGameJoin);
        MinecraftForge.EVENT_BUS.addListener(Events::tickEnd);
        MinecraftForge.EVENT_BUS.addListener(Events::onWorldRenderLast);
    }

    private static void onSetup(FMLCommonSetupEvent event) {
        XRay.logger.debug(I18n.m_118938_((String)"xray.debug.init", (Object[])new Object[0]));
        KeyBindings.setup();
        List<BlockData.SerializableBlockData> data = blockStore.read();
        if (data.isEmpty()) {
            return;
        }
        ArrayList<BlockData> map = BlockStore.getFromSimpleBlockList(data);
        Controller.getBlockStore().setStore(map);
    }

    private static void onGameJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (!((Boolean)Configuration.firstRun.get()).booleanValue()) {
            return;
        }
        if (!event.getLevel().m_5776_() || !((entity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        player.m_5661_((Component)Component.m_237110_((String)"xray.chat.first-time", (Object[])new Object[]{KeyBindings.toggleGui.getKey().m_84875_().m_6881_().m_130940_(ChatFormatting.GREEN), KeyBindings.toggleXRay.getKey().m_84875_().m_6881_().m_130940_(ChatFormatting.GREEN)}), false);
        player.m_5661_((Component)Component.m_237115_((String)"xray.chat.first-time-line-2"), false);
        Configuration.firstRun.set((Object)false);
        Configuration.firstRun.save();
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        gameBlockStore.populate();
    }
}

