/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.gui.manage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import pro.mikey.xray.ClientController;
import pro.mikey.xray.gui.GuiSelectionScreen;
import pro.mikey.xray.gui.manage.GuiAddBlock;
import pro.mikey.xray.gui.utils.GuiBase;
import pro.mikey.xray.gui.utils.ScrollingList;
import pro.mikey.xray.store.GameBlockStore;

public class GuiBlockList
extends GuiBase {
    private ScrollingBlockList blockList;
    private ArrayList<GameBlockStore.BlockWithItemStack> blocks = ClientController.gameBlockStore.getStore();
    private EditBox search;
    private String lastSearched = "";

    public GuiBlockList() {
        super(false);
    }

    public void m_7856_() {
        this.blockList = new ScrollingBlockList(this.getWidth() / 2 + 1, this.getHeight() / 2 - 12, 202, 185, this.blocks);
        this.m_142416_((GuiEventListener)this.blockList);
        this.search = new EditBox(this.getFontRender(), this.getWidth() / 2 - 100, this.getHeight() / 2 + 85, 140, 18, (Component)Component.m_237113_((String)""));
        this.search.m_93692_(true);
        this.m_7522_((GuiEventListener)this.search);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"xray.single.cancel"), b -> {
            this.m_7379_();
            Minecraft.m_91087_().m_91152_((Screen)new GuiSelectionScreen());
        }).m_252794_(this.getWidth() / 2 + 43, this.getHeight() / 2 + 84).m_253046_(60, 20).m_253136_());
    }

    public void m_86600_() {
        this.search.m_94120_();
        if (!this.search.m_94155_().equals(this.lastSearched)) {
            this.reloadBlocks();
        }
        super.m_86600_();
    }

    private void reloadBlocks() {
        if (this.lastSearched.equals(this.search.m_94155_())) {
            return;
        }
        this.blockList.updateEntries(this.search.m_94155_().length() == 0 ? this.blocks : this.blocks.stream().filter(e -> e.getItemStack().m_41786_().getString().toLowerCase().contains(this.search.m_94155_().toLowerCase())).collect(Collectors.toList()));
        this.lastSearched = this.search.m_94155_();
        this.blockList.m_93410_(0.0);
    }

    @Override
    public void renderExtra(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.search.m_88315_(graphics, x, y, partialTicks);
        this.blockList.m_88315_(graphics, x, y, partialTicks);
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.search.m_6375_(x, y, button)) {
            this.m_7522_((GuiEventListener)this.search);
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.blockList.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        return super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;

        ScrollingBlockList(int x, int y, int width, int height, List<GameBlockStore.BlockWithItemStack> blocks) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
        }

        public void setSelected(@Nullable BlockSlot entry) {
            if (entry == null) {
                return;
            }
            Minecraft.m_91087_().f_91074_.m_6915_();
            Minecraft.m_91087_().m_91152_((Screen)new GuiAddBlock(entry.getBlock().getBlock(), GuiBlockList::new));
        }

        void updateEntries(List<GameBlockStore.BlockWithItemStack> blocks) {
            this.m_93516_();
            blocks.forEach(block -> this.m_7085_(new BlockSlot((GameBlockStore.BlockWithItemStack)block, this)));
        }

        public static class BlockSlot
        extends AbstractSelectionList.Entry<BlockSlot> {
            GameBlockStore.BlockWithItemStack block;
            ScrollingBlockList parent;

            BlockSlot(GameBlockStore.BlockWithItemStack block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public GameBlockStore.BlockWithItemStack getBlock() {
                return this.block;
            }

            public void m_6311_(GuiGraphics graphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                Font font = ((ScrollingBlockList)this.parent).f_93386_.f_91062_;
                ResourceLocation resource = ForgeRegistries.ITEMS.getKey((Object)this.block.getItemStack().m_41720_());
                graphics.m_280488_(font, this.block.getItemStack().m_41720_().m_41466_().getString(), left + 35, top + 7, Color.WHITE.getRGB());
                graphics.m_280488_(font, resource != null ? resource.m_135827_() : "", left + 35, top + 17, Color.WHITE.getRGB());
                graphics.m_280480_(this.block.getItemStack(), left + 8, top + 7);
                graphics.m_280370_(font, this.block.getItemStack(), left + 8, top + 7);
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                this.parent.setSelected(this);
                return false;
            }
        }
    }
}

