/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.behaviour.ammo;

import com.milamber_brass.brass_armory.behaviour.ammo.AbstractAmmoBehaviour;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractBulletEntity;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BulletAmmoBehaviour
extends AbstractAmmoBehaviour {
    protected final BiFunction<Level, LivingEntity, AbstractBulletEntity> newProjectileFunction;
    protected final Predicate<ItemStack> ammoItems;

    public BulletAmmoBehaviour(Predicate<ItemStack> ammoItems, BiFunction<Level, LivingEntity, AbstractBulletEntity> newProjectileFunction) {
        this.ammoItems = ammoItems;
        this.newProjectileFunction = newProjectileFunction;
    }

    @Override
    public boolean onShoot(Level level, LivingEntity owner, Entity shooter, ItemStack ammoStack, @Nullable AbstractPowderBehaviour powderBehaviour, iGun gun) {
        super.onShoot(level, owner, shooter, ammoStack, powderBehaviour, gun);
        AbstractBulletEntity bullet = this.newProjectileFunction.apply(level, owner);
        bullet.setItem(ammoStack);
        if (powderBehaviour != null) {
            powderBehaviour.applyEffect((Entity)bullet);
        }
        if (!level.f_46443_) {
            float speed = gun.speed();
            bullet.m_37251_(shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, speed, gun.accuracy());
            bullet.m_146884_(shooter.m_146892_());
            bullet.m_36781_(gun.damage() / (double)speed);
            gun.onShoot(level, owner, shooter, ammoStack, (Projectile)bullet);
            return level.m_7967_((Entity)bullet);
        }
        return true;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getAmmoItems() {
        return this.ammoItems;
    }
}

