/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.capabilities;

import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import com.milamber_brass.brass_armory.capabilities.IPowderCapability;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class PowderCapabilityHandler
implements IPowderCapability {
    private Projectile projectile;
    private AbstractPowderBehaviour powderBehaviour;

    @Override
    public void setEntity(Projectile projectile) {
        this.projectile = projectile;
    }

    @Override
    public void setPowderBehaviour(AbstractPowderBehaviour powderBehaviour) {
        this.powderBehaviour = powderBehaviour;
    }

    @Override
    public AbstractPowderBehaviour getPowderBehaviour() {
        return this.powderBehaviour;
    }

    @Override
    public void tick() {
        Level level = this.projectile.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.powderBehaviour != null) {
                Projectile projectile = this.projectile;
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow abstractArrow = (AbstractArrow)projectile;
                    if (abstractArrow.f_36703_ && abstractArrow.f_36706_ <= 0) {
                        return;
                    }
                }
                this.powderBehaviour.sendParticles(serverLevel, this.projectile.m_146892_());
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        GunBehaviours.resourceLocationByPowderBehaviour(this.powderBehaviour).ifPresent(resourceLocation -> tag.m_128359_("BAPowderBehaviour", resourceLocation.toString()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)tag.m_128461_("BAPowderBehaviour"));
        if (resourceLocation != null) {
            this.powderBehaviour = GunBehaviours.getPowderBehaviours().get(resourceLocation);
        }
    }
}

