/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.client.gui;

import com.milamber_brass.brass_armory.inventory.QuiverTooltip;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class ClientQuiverTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private final NonNullList<ItemStack> items;
    private final int weight;

    public ClientQuiverTooltip(QuiverTooltip quiverTooltip) {
        this.items = quiverTooltip.getItems();
        this.weight = quiverTooltip.getWeight();
    }

    public int m_142103_() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18 + 2;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        boolean flag = this.weight >= 256;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = x + i1 * 18 + 1;
                int k1 = y + l * 20 + 1;
                this.renderSlot(j1, k1, k++, flag, graphics, font);
            }
        }
        this.drawBorder(x, y, i, j, graphics);
    }

    private void renderSlot(int x, int y, int i, boolean blocked, GuiGraphics graphics, Font font) {
        if (i >= this.items.size()) {
            this.blit(graphics, x, y, blocked ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            this.blit(graphics, x, y, Texture.SLOT);
            graphics.m_280256_(itemstack, x + 1, y + 1, i);
            graphics.m_280370_(font, itemstack, x + 1, y + 1);
            if (i == 0) {
                AbstractContainerScreen.m_280359_((GuiGraphics)graphics, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void drawBorder(int x, int y, int xSize, int ySize, GuiGraphics graphics) {
        this.blit(graphics, x, y, Texture.BORDER_CORNER_TOP);
        this.blit(graphics, x + xSize * 18 + 1, y, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < xSize; ++i) {
            this.blit(graphics, x + 1 + i * 18, y, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(graphics, x + 1 + i * 18, y + ySize * 20, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < ySize; ++j) {
            this.blit(graphics, x, y + j * 20 + 1, Texture.BORDER_VERTICAL);
            this.blit(graphics, x + xSize * 18 + 1, y + j * 20 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(graphics, x, y + ySize * 20, Texture.BORDER_CORNER_BOTTOM);
        this.blit(graphics, x + xSize * 18 + 1, y + ySize * 20, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(GuiGraphics graphics, int x, int y, Texture texture) {
        graphics.m_280398_(TEXTURE_LOCATION, x, y, 0, (float)texture.x, (float)texture.y, texture.w, texture.h, 128, 128);
    }

    private int gridSizeX() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.items.size() + 1.0)));
    }

    private int gridSizeY() {
        return (int)Math.ceil(((double)this.items.size() + 1.0) / (double)this.gridSizeX());
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

