/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BattleaxeEntity
extends AbstractThrownWeaponEntity {
    public BattleaxeEntity(EntityType<BattleaxeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BattleaxeEntity(LivingEntity livingEntity, Level level, ItemStack battleaxeStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.BATTLEAXE.get()), livingEntity, level, battleaxeStack);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36384_(true);
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    protected ResourceKey<DamageType> onHitDamageType() {
        return BrassArmoryDamageTypes.BATTLE_AXE;
    }

    protected void m_8060_(BlockHitResult result) {
        ItemStack battleaxeStack = this.m_7846_();
        Item item = battleaxeStack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            BlockPos pos = result.m_82425_();
            BlockState hitBlockState = this.m_9236_().m_8055_(pos);
            if ((hitBlockState.m_60734_() instanceof DoorBlock || hitBlockState.m_60734_() instanceof TrapDoorBlock) && !TierSortingRegistry.getTiersLowerThan((Tier)Tiers.DIAMOND).contains(tieredItem.m_43314_())) {
                Vec3 deltaMovement = this.onHitDeltaMovement();
                this.m_9236_().m_46953_(pos, true, this.m_19749_());
                this.m_20256_(deltaMovement);
                return;
            }
        }
        super.m_8060_(result);
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.BATTLEAXE_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.BATTLEAXE_HIT_GROUND.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_DAGGER.get();
    }
}

