/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.SpearItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SpearEntity
extends AbstractThrownWeaponEntity {
    public SpearEntity(EntityType<SpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SpearEntity(Level level, LivingEntity livingEntity, ItemStack spearStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SPEAR.get()), livingEntity, level, spearStack);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity living;
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6095_() != EntityType.f_20566_ && this.m_7846_().m_41720_() instanceof SpearItem) {
            ArmoryUtil.impaleLivingEntity(living, ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue(), this.m_9236_().f_46441_);
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    protected ResourceKey<DamageType> onHitDamageType() {
        return BrassArmoryDamageTypes.SPEAR;
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.SPEAR_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.SPEAR_HIT_GROUND.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_SPEAR.get();
    }
}

