/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.bomb;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractRollableItemProjectileEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BombEntity
extends AbstractRollableItemProjectileEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE = SynchedEntityData.m_135353_(BombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean defused;

    public BombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    public BombEntity(Level level, LivingEntity livingEntity, @Nullable HumanoidArm arm) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.BOMB.get()), livingEntity, level, arm);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    public BombEntity(Level level, LivingEntity livingEntity) {
        this(level, livingEntity, null);
    }

    public BombEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.BOMB.get()), x, y, z, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FUSE, (Object)80);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)BrassArmoryItems.BOMB.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        int newFuse = this.getFuse() - (this.m_6060_() ? 2 : 1);
        this.setFuse(newFuse);
        if (newFuse <= 0) {
            this.m_146870_();
            if (!this.defused && !this.m_9236_().f_46443_) {
                this.explode(this.m_9236_());
            }
        }
        if (!this.defused) {
            if (this.m_9236_().f_46443_ && this.m_9236_().m_213780_().m_188503_(2) == 1) {
                Vec3 smokeVec = this.m_20182_().m_82549_(this.m_20184_().m_82542_(-1.5, -1.5, -1.5)).m_82520_(0.0, 0.125, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
            }
            this.m_5496_((SoundEvent)BrassArmorySounds.BOMB_FUSE.get(), 0.03f, this.m_9236_().m_213780_().m_188501_() * 0.6f + 1.0f);
            if (this.m_20072_()) {
                this.setFuse(40);
                this.defused = true;
            }
        }
    }

    public void m_20093_() {
        this.explode(this.m_9236_());
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        this.explode(this.m_9236_());
    }

    @Override
    @Nonnull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.defused && !this.m_20096_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BrassArmoryAdvancements.CATCH_BOMB.trigger(serverPlayer);
        }
        return this.defused ? InteractionResult.PASS : super.m_6096_(player, hand);
    }

    @Nonnull
    public ItemStack m_7846_() {
        return (ItemStack)Util.m_137469_((Object)super.m_7846_(), stack -> {
            BombItem.setFuseLit(stack, true);
            BombItem.setFuseLength(stack, this.getFuse());
            stack.m_41636_((Entity)this);
        });
    }

    @Override
    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.hitPerTick == 7) {
            this.explode(this.m_9236_());
            return;
        }
        super.m_8060_(blockHitResult);
    }

    @Override
    protected double getBounceMultiplier() {
        return 0.3;
    }

    @Override
    protected SoundEvent getSoundEvent() {
        return (SoundEvent)BrassArmorySounds.BOMB_HIT.get();
    }

    @Override
    protected float getVolumeMultiplier() {
        return 0.5f;
    }

    public double m_6049_() {
        return 0.25;
    }

    protected void explode(Level level) {
        if (!this.m_213877_()) {
            this.m_146870_();
        }
        if (!level.f_46443_) {
            BombEntity.explode(level, (Entity)this);
        }
    }

    public static void explode(Level level, Entity victim) {
        BombEntity bombEntity;
        BombEntity bomb;
        BombEntity bombEntity2 = bomb = victim instanceof BombEntity ? (bombEntity = (BombEntity)victim) : null;
        if (bomb != null && bomb.m_20202_() != null) {
            victim = bomb.m_20202_();
        }
        ArmoryUtil.explode(level, (Entity)bomb, victim.m_20182_().m_82520_(0.0, (double)(victim.m_20206_() * 0.5f), 0.0), 2.0f, bomb != null && bomb.m_6060_(), Level.ExplosionInteraction.TNT);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128376_("Fuse", (short)this.getFuse());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        this.setFuse(compoundTag.m_128448_("Fuse"));
    }

    public void setFuse(int newFuse) {
        this.f_19804_.m_135381_(DATA_FUSE, (Object)newFuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE);
    }

    public boolean getDefused() {
        return this.defused;
    }
}

