/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.cannon_balls;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractBulletEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SiegeRoundEntity
extends AbstractBulletEntity {
    public SiegeRoundEntity(EntityType<? extends AbstractBulletEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SiegeRoundEntity(Level level, LivingEntity livingEntity) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SIEGE_ROUND.get()), livingEntity, level);
    }

    public SiegeRoundEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SIEGE_ROUND.get()), x, y, z, level);
    }

    public void m_37251_(Entity shooter, float xRot, float yRot, float v, float speed, float accuracy) {
        super.m_37251_(shooter, xRot, yRot, v, speed * 0.5f, accuracy);
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        if (!this.m_9236_().f_46443_) {
            ArmoryUtil.explode(this.m_9236_(), (Entity)this, 4.0f, this.m_6060_(), Level.ExplosionInteraction.TNT);
            this.m_146870_();
        }
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            ArmoryUtil.explode(this.m_9236_(), (Entity)this, 4.0f, this.m_6060_(), Level.ExplosionInteraction.TNT);
            if (entityHitResult.m_82443_() instanceof Creeper && (entity = this.m_19749_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BrassArmoryAdvancements.SIEGE.trigger(serverPlayer);
            }
            this.m_146870_();
        }
    }

    @Override
    @NotNull
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.SIEGE_ROUND.get();
    }
}

