/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.data.BrassAdvancementProvider;
import com.milamber_brass.brass_armory.data.BrassArmoryBlockModelBuilder;
import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.data.BrassArmoryLootModifierProvider;
import com.milamber_brass.brass_armory.data.BrassArmoryRecipeProvider;
import com.milamber_brass.brass_armory.data.BrassArmorySpriteSourceProvider;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brass_armory", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataEventSubscriber {
    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = evt.getLookupProvider();
        ExistingFileHelper helper = evt.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new BrassArmoryRecipeProvider(output));
        BrassArmoryTags.Blocks blockTagsProvider = new BrassArmoryTags.Blocks(output, provider, helper);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new BrassArmoryTags.Items(output, provider, blockTagsProvider.m_274426_(), helper));
        generator.addProvider(true, (DataProvider)new BrassArmoryTags.Entities(output, provider, helper));
        generator.addProvider(true, (DataProvider)new BrassAdvancementProvider(output, provider, helper));
        generator.addProvider(true, (DataProvider)new BrassArmoryLootModifierProvider(output));
        generator.addProvider(true, (DataProvider)new BrassArmorySpriteSourceProvider(output, helper));
        generator.addProvider(true, (DataProvider)new BrassArmoryBlockModelBuilder(output, helper));
        BrassArmoryDamageTypes.addProviders(evt.includeServer(), generator, output, provider, helper);
    }
}

