/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class KatanaItem
extends SwordItem {
    private final boolean canWither;
    private static final MutableComponent wilted = Component.m_237115_((String)"item.brass_armory.katana_wilted");
    private static final MutableComponent withered = Component.m_237115_((String)"item.brass_armory.katana_withered");

    public KatanaItem(Tier tier, int attackDamage, float attackSpeed, boolean canWither, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.canWither = canWither;
    }

    public boolean canWither() {
        return this.canWither;
    }

    @NotNull
    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return target.m_20191_().m_82377_(3.0, 0.25, 3.0);
    }

    public static void addWither(ItemStack stack, LivingEntity living, ServerLevel serverLevel, int amount) {
        int newWither = KatanaItem.getWither(stack);
        boolean ten = false;
        boolean fifty = false;
        for (int i = 0; i < amount; ++i) {
            if (++newWither % 10 == 0) {
                ten = true;
            }
            if (newWither % 50 != 0) continue;
            fifty = true;
        }
        newWither = Math.min(newWither, 100);
        KatanaItem.setWither(stack, newWither);
        if (ten) {
            SoundSource source = living instanceof Player ? SoundSource.PLAYERS : (living instanceof Enemy ? SoundSource.HOSTILE : SoundSource.NEUTRAL);
            serverLevel.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)BrassArmorySounds.KATANA_SMALL_UPGRADE.get(), source, (float)newWither / 100.0f, 1.2f - (float)newWither / 100.0f);
            if (fifty) {
                serverLevel.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)BrassArmorySounds.KATANA_LARGE_UPGRADE.get(), source, (float)newWither / 100.0f, 0.7f);
                if (living instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)living;
                    if (newWither == 100) {
                        BrassArmoryAdvancements.WITHER_KATANA_TRIGGER.trigger(serverPlayer);
                    }
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    public static void setWither(ItemStack stack, int wither) {
        stack.m_41784_().m_128405_("BrassArmoryWithering", wither);
    }

    @ParametersAreNonnullByDefault
    public static int getWither(ItemStack stack) {
        return stack.m_41784_().m_128451_("BrassArmoryWithering");
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        int wither = KatanaItem.getWither(stack);
        if (wither < 50) {
            return super.m_7626_(stack);
        }
        if (wither < 100) {
            return wilted;
        }
        return withered;
    }
}

