/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.inventory.QuiverTooltip;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class QuiverItem
extends Item {
    public static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 256;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public QuiverItem(Item.Properties properties) {
        super(properties);
    }

    public static float getFullnessDisplay(ItemStack stack) {
        return (float)QuiverItem.getContentWeight(stack) / 256.0f;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = slot.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            QuiverItem.removeOne(stack).ifPresent(itemStack -> QuiverItem.add(stack, slot.m_150659_(itemStack)));
        } else if (itemstack.m_204117_(ItemTags.f_13161_) && itemstack.m_41720_().m_142095_()) {
            int i = (256 - QuiverItem.getContentWeight(stack)) / QuiverItem.getWeight(itemstack);
            int j = QuiverItem.add(stack, slot.m_150647_(itemstack.m_41613_(), i, player));
            if (j > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack stack, ItemStack stack1, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (stack1.m_41619_()) {
                QuiverItem.removeOne(stack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(itemStack);
                });
            } else {
                int i = QuiverItem.add(stack, stack1);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                    stack1.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        player.getCapability(BrassArmoryCapabilities.QUIVER_CAPABILITY).ifPresent(cap -> cap.getAmmoStack().m_41774_(1));
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (QuiverItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack stack) {
        return QuiverItem.getContentWeight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * QuiverItem.getContentWeight(stack) / 256, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public static int add(ItemStack stack, ItemStack stack1) {
        if (!stack1.m_41619_() && stack1.m_204117_(ItemTags.f_13161_) && stack1.m_41720_().m_142095_()) {
            CompoundTag compoundTag = stack.m_41784_();
            if (!compoundTag.m_128441_(TAG_ITEMS)) {
                compoundTag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = QuiverItem.getContentWeight(stack);
            int j = QuiverItem.getWeight(stack1);
            int k = Math.min(stack1.m_41613_(), (256 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundTag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = QuiverItem.getMatchingItem(stack1, listtag);
            if (optional.isPresent()) {
                int currentSize;
                CompoundTag compoundTag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundTag1);
                int maxSize = itemstack.m_41741_();
                if (maxSize == (currentSize = itemstack.m_41613_())) {
                    ItemStack stack2 = stack1.m_41777_();
                    stack2.m_41764_(k);
                    CompoundTag compoundTag2 = new CompoundTag();
                    stack2.m_41739_(compoundTag2);
                    listtag.add(0, (Tag)compoundTag2);
                } else if (currentSize + k <= maxSize) {
                    itemstack.m_41769_(k);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                } else {
                    itemstack.m_41764_(maxSize);
                    itemstack.m_41739_(compoundTag1);
                    listtag.remove((Object)compoundTag1);
                    listtag.add(0, (Tag)compoundTag1);
                    ItemStack stack2 = stack1.m_41777_();
                    stack2.m_41764_(k - (maxSize - currentSize));
                    CompoundTag compoundTag2 = new CompoundTag();
                    stack2.m_41739_(compoundTag2);
                    listtag.add(0, (Tag)compoundTag2);
                }
            } else {
                ItemStack stack2 = stack1.m_41777_();
                stack2.m_41764_(k);
                CompoundTag compoundTag1 = new CompoundTag();
                stack2.m_41739_(compoundTag1);
                listtag.add(0, (Tag)compoundTag1);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag listTag) {
        return stack.m_150930_(Items.f_151058_) ? Optional.empty() : listTag.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)stack)).findFirst();
    }

    private static int getWeight(ItemStack stack) {
        CompoundTag compoundtag;
        if (stack.m_150930_(Items.f_151058_)) {
            return 4 + QuiverItem.getContentWeight(stack);
        }
        if ((stack.m_150930_(Items.f_42786_) || stack.m_150930_(Items.f_42785_)) && stack.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)stack)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / stack.m_41741_();
    }

    private static int getContentWeight(ItemStack stack) {
        return QuiverItem.getContents(stack).mapToInt(itemStack -> QuiverItem.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    public static Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundTag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listtag.m_128728_(0));
        listtag.remove(0);
        if (listtag.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listtag = compoundTag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundTag1);
                player.m_36176_(itemstack, true);
            }
        }
        stack.m_41749_(TAG_ITEMS);
        return true;
    }

    public static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        QuiverItem.getContents(stack).forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new QuiverTooltip((NonNullList<ItemStack>)nonNullList, QuiverItem.getContentWeight(stack)));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{QuiverItem.getContentWeight(stack), 256}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, QuiverItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

