/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item.abstracts;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.item.abstracts.AbstractTieredWeaponItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public abstract class AbstractThrownWeaponItem
extends AbstractTieredWeaponItem {
    public static final UUID BASE_ATTACK_RANGE_UUID = UUID.fromString("88a8a0f7-2afd-48b5-8169-2e1f30fd408d");
    public final float chargeDuration;
    protected final float throwMultiplier;

    public AbstractThrownWeaponItem(Tier tier, float attackDamage, float attackSpeed, float chargeDuration, float throwMultiplier, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.chargeDuration = chargeDuration;
        this.throwMultiplier = throwMultiplier;
    }

    public float getThrowMultiplier() {
        return this.throwMultiplier;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack boomerangStack) {
        return UseAnim.SPEAR;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            float time = this.m_8105_(stack) - timeLeft;
            if (time >= 5.0f) {
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(entityLiving.m_7655_()));
                    AbstractThrownWeaponEntity thrownWeapon = this.getEntity(level, (LivingEntity)playerEntity, stack.m_41777_());
                    float power = Math.min(time / this.chargeDuration, 1.0f);
                    thrownWeapon.setPower(power);
                    thrownWeapon.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, power * this.throwMultiplier, 1.0f);
                    if (playerEntity.m_150110_().f_35937_) {
                        thrownWeapon.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else if (this.shrinkItem()) {
                        stack.m_41774_(1);
                    }
                    level.m_7967_((Entity)thrownWeapon);
                    level.m_6269_(null, (Entity)thrownWeapon, this.throwSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    public abstract SoundEvent throwSound();

    protected boolean shrinkItem() {
        return true;
    }

    @Nonnull
    protected abstract AbstractThrownWeaponEntity getEntity(Level var1, LivingEntity var2, ItemStack var3);

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44955_;
    }
}

