/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.loot;

import com.google.common.base.Suppliers;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.WarpCrystalItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class WarpCrystalLootModifier
extends LootModifier {
    public static final Supplier<Codec<WarpCrystalLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> WarpCrystalLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("loot_generator").forGetter(m -> m.loot_generator)).apply((Applicative)inst, WarpCrystalLootModifier::new)));
    private final Item loot_generator;

    public WarpCrystalLootModifier(LootItemCondition[] conditionsIn, Item loot_generator) {
        super(conditionsIn);
        this.loot_generator = loot_generator;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (ItemStack stack : generatedLoot) {
            if (!stack.m_150930_(this.loot_generator)) continue;
            int roll = context.m_230907_().m_188503_(100) - context.getLootingModifier() * 2 - (int)context.m_78945_();
            if (roll < 2) {
                generatedLoot.add((Object)((WarpCrystalItem)((Object)BrassArmoryItems.GRAND_WARP_CRYSTAL.get())).m_7968_());
                continue;
            }
            if (roll < 6) {
                generatedLoot.add((Object)((WarpCrystalItem)((Object)BrassArmoryItems.GREATER_WARP_CRYSTAL.get())).m_7968_());
                continue;
            }
            if (roll < 14) {
                generatedLoot.add((Object)((WarpCrystalItem)((Object)BrassArmoryItems.COMMON_WARP_CRYSTAL.get())).m_7968_());
                continue;
            }
            if (roll < 30) {
                generatedLoot.add((Object)((WarpCrystalItem)((Object)BrassArmoryItems.LESSER_WARP_CRYSTAL.get())).m_7968_());
                continue;
            }
            if (roll >= 62) continue;
            generatedLoot.add((Object)((WarpCrystalItem)((Object)BrassArmoryItems.PETTY_WARP_CRYSTAL.get())).m_7968_());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

