/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.recipe;

import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmoryRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CarcassRoundRecipe
extends CustomRecipe {
    private List<Recipe<?>> CARCASS_ROUND_RECIPES = new ArrayList();

    public CarcassRoundRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        this.CARCASS_ROUND_RECIPES = level.m_7465_().m_44051_().stream().filter(recipe -> recipe.m_8043_(level.m_9598_()).m_150930_((Item)BrassArmoryItems.CARCASS_ROUND.get())).toList();
        for (Recipe<?> recipe2 : this.CARCASS_ROUND_RECIPES) {
            ShapelessRecipe shapelessRecipe;
            if (recipe2 instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
                if (shapedRecipe.m_5818_(inv, level)) {
                    return true;
                }
                for (int i = 0; i <= inv.m_39347_() - shapedRecipe.m_44220_(); ++i) {
                    for (int j = 0; j <= inv.m_39346_() - shapedRecipe.m_44221_(); ++j) {
                        if (!CarcassRoundRecipe.matches(inv, shapedRecipe, i, j, true).m_41619_()) {
                            return true;
                        }
                        if (CarcassRoundRecipe.matches(inv, shapedRecipe, i, j, false).m_41619_()) continue;
                        return true;
                    }
                }
                continue;
            }
            if (!(recipe2 instanceof ShapelessRecipe) || !(shapelessRecipe = (ShapelessRecipe)recipe2).m_5818_(inv, level) && CarcassRoundRecipe.matches(inv, shapelessRecipe).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ItemStack matches(CraftingContainer container, ShapedRecipe shapedRecipe, int m, int n, boolean b) {
        ItemStack itemStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_39347_(); ++i) {
            for (int j = 0; j < container.m_39346_(); ++j) {
                ItemStack stack;
                int k = i - m;
                int l = j - n;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < shapedRecipe.m_44220_() && l < shapedRecipe.m_44221_()) {
                    ingredient = b ? (Ingredient)shapedRecipe.m_7527_().get(shapedRecipe.m_44220_() - k - 1 + l * shapedRecipe.m_44220_()) : (Ingredient)shapedRecipe.m_7527_().get(k + l * shapedRecipe.m_44220_());
                }
                if (!(ingredient.test(stack = container.m_8020_(i + j * container.m_39347_())) || !ingredient.m_43947_() && ingredient.m_43908_().length > 0 && CarcassRoundRecipe.isLingeringPotionItem(stack.m_41720_()) && CarcassRoundRecipe.isLingeringPotionItem(ingredient.m_43908_()[0].m_41720_()))) {
                    return ItemStack.f_41583_;
                }
                if (!CarcassRoundRecipe.isLingeringPotionItem(stack.m_41720_())) continue;
                itemStack = stack.m_41777_();
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack matches(CraftingContainer container, ShapelessRecipe recipe) {
        ItemStack itemStack = ItemStack.f_41583_;
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        boolean isSimple = recipe.m_7527_().stream().allMatch(Ingredient::isSimple);
        int i = 0;
        for (int j = 0; j < container.m_6643_(); ++j) {
            ItemStack itemstack = container.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (CarcassRoundRecipe.isLingeringPotionItem(itemstack.m_41720_())) {
                itemStack = itemstack.m_41777_();
                itemstack = new ItemStack((ItemLike)Items.f_42739_, itemstack.m_41613_());
            }
            ++i;
            if (isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        if (i == recipe.m_7527_().size() && (isSimple ? stackedcontents.m_36475_((Recipe)recipe, null) : RecipeMatcher.findMatches(inputs, (List)recipe.m_7527_()) != null)) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isLingeringPotionItem(Item item) {
        return item instanceof LingeringPotionItem || item.equals(Items.f_42735_);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        for (Recipe<?> recipe : this.CARCASS_ROUND_RECIPES) {
            ShapelessRecipe shapelessRecipe;
            ItemStack stack;
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                for (int i = 0; i <= inv.m_39347_() - shapedRecipe.m_44220_(); ++i) {
                    for (int j = 0; j <= inv.m_39346_() - shapedRecipe.m_44221_(); ++j) {
                        for (int b = 0; b < 2; ++b) {
                            ItemStack stack2 = CarcassRoundRecipe.matches(inv, shapedRecipe, i, j, b == 0);
                            if (stack2.m_41619_()) continue;
                            ItemStack result = shapedRecipe.m_8043_(access).m_41777_();
                            if (stack2.m_150930_(Items.f_42735_)) {
                                result.m_41784_().m_128379_("BADragonRound", true);
                            } else {
                                PotionUtils.m_43549_((ItemStack)result, (Potion)PotionUtils.m_43579_((ItemStack)stack2));
                            }
                            return result;
                        }
                    }
                }
                continue;
            }
            if (!(recipe instanceof ShapelessRecipe) || (stack = CarcassRoundRecipe.matches(inv, shapelessRecipe = (ShapelessRecipe)recipe)).m_41619_()) continue;
            ItemStack result = shapelessRecipe.m_8043_(access).m_41777_();
            if (stack.m_150930_(Items.f_42735_)) {
                result.m_41784_().m_128379_("BADragonRound", true);
            } else {
                PotionUtils.m_43549_((ItemStack)result, (Potion)PotionUtils.m_43579_((ItemStack)stack));
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BrassArmoryRecipes.CARCASS_ROUND_CUSTOM_RECIPE.get();
    }
}

