/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.forge.RenderUtilImpl;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class RenderUtil {
    static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        void var8_7;
        void var7_6;
        void var6_5;
        void var5_4;
        void var4_3;
        void var3_2;
        void var1_1;
        RenderUtilImpl.renderBlock(model, (long)var1_1, (PoseStack)var3_2, (MultiBufferSource)var4_3, (BlockState)var5_4, (Level)var6_5, (BlockPos)var7_6, (BlockRenderDispatcher)var8_7);
    }

    public static void renderBlock(long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        BakedModel model = dispatcher.m_110910_(state);
        RenderUtil.renderBlock(model, seed, poseStack, buffer, state, level, pos, dispatcher);
    }

    @Deprecated(forRemoval=true)
    public static void renderBlockModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        RenderUtil.renderModel(modelLocation, matrixStack, buffer, blockRenderer, light, overlay, cutout);
    }

    public static void renderModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        blockRenderer.m_110937_().m_111067_(matrixStack.m_85850_(), buffer.m_6299_(cutout ? Sheets.m_110790_() : Sheets.m_110789_()), null, ClientHelper.getModel(blockRenderer.m_110907_().m_110881_(), modelLocation), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement) {
        RenderUtil.renderGuiItemRelative(poseStack, stack, x, y, renderer, movement, 0xF000F0, OverlayTexture.f_118083_);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement, int combinedLight, int pCombinedOverlay) {
        boolean flag;
        BakedModel model = renderer.m_174264_(stack, null, null, 0);
        int l = 0;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, (float)(50 + (model.m_7539_() ? l : 0)));
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 150.0f);
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        } else {
            Lighting.m_84931_();
        }
        ItemDisplayContext pTransformType = ItemDisplayContext.GUI;
        if (stack.m_150930_(Items.f_42713_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(TRIDENT_MODEL);
        } else if (stack.m_150930_(Items.f_151059_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(SPYGLASS_MODEL);
        }
        model = RenderUtil.handleCameraTransforms(model, poseStack, pTransformType);
        movement.accept(poseStack, model);
        RenderUtil.renderGuiItem(model, stack, renderer, combinedLight, pCombinedOverlay, poseStack, bufferSource, flag);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BakedModel handleCameraTransforms(BakedModel model, PoseStack matrixStack, ItemDisplayContext pTransformType) {
        void var2_2;
        void var1_1;
        return RenderUtilImpl.handleCameraTransforms(model, (PoseStack)var1_1, (ItemDisplayContext)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderGuiItem(BakedModel model, ItemStack stack, ItemRenderer renderer, int combinedLight, int pCombinedOverlay, PoseStack poseStack, MultiBufferSource.BufferSource buffer, boolean flatItem) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        RenderUtilImpl.renderGuiItem(model, (ItemStack)var1_1, (ItemRenderer)var2_2, (int)var3_3, (int)var4_4, (PoseStack)var5_5, (MultiBufferSource.BufferSource)var6_6, (boolean)var7_7);
    }

    public static GuiGraphics getGuiDummy(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        return new GuiGraphics(mc, poseStack, mc.m_91269_().m_110104_());
    }

    public static void blitSpriteSection(GuiGraphics graphics, int x, int y, int w, int h, float u, float v, int uW, int vH, TextureAtlasSprite sprite) {
        SpriteContents c = sprite.m_245424_();
        int width = (int)((float)c.m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
        int height = (int)((float)c.m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
        graphics.m_280411_(sprite.m_247685_(), x, y, w, h, sprite.m_118367_((double)u) * (float)width, (float)height * sprite.m_118393_((double)v), uW, vH, width, height);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index, int b, int g, int r, TextureAtlasSprite sprite) {
        RenderUtil.renderSprite(stack, vertexBuilder, light, index, b, g, r, 255, sprite);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index, int b, int g, int r, int a, TextureAtlasSprite sprite) {
        Matrix4f matrix4f1 = stack.m_85850_().m_252922_();
        float u0 = sprite.m_118367_(0.0);
        float u1 = sprite.m_118367_(16.0);
        float h = (u0 + u1) / 2.0f;
        float v0 = sprite.m_118393_(0.0);
        float v1 = sprite.m_118393_(16.0);
        float k = (v0 + v1) / 2.0f;
        float shrink = sprite.m_118417_();
        float u0s = Mth.m_14179_((float)shrink, (float)u0, (float)h);
        float u1s = Mth.m_14179_((float)shrink, (float)u1, (float)h);
        float v0s = Mth.m_14179_((float)shrink, (float)v0, (float)k);
        float v1s = Mth.m_14179_((float)shrink, (float)v1, (float)k);
        vertexBuilder.m_252986_(matrix4f1, -1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, a).m_7421_(u0s, v1s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, 1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, a).m_7421_(u1s, v1s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, 1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, a).m_7421_(u1s, v0s).m_85969_(light).m_5752_();
        vertexBuilder.m_252986_(matrix4f1, -1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, a).m_7421_(u0s, v0s).m_85969_(light).m_5752_();
    }

    public static RenderType getTextMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.TEXT_MIP.apply(texture);
    }

    public static RenderType getEntityCutoutMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_CUTOUT_MIP.apply(texture);
    }

    public static RenderType getEntitySolidMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_SOLID_MIP.apply(texture);
    }

    public static RenderType getTextColorRenderType(ResourceLocation texture) {
        return MLRenderTypes.COLOR_TEXT.apply(texture);
    }

    public static void setDynamicTexturesToUseMipmap(boolean mipMap) {
        MoonlightClient.setMipMap(mipMap);
    }
}

