/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsModSounds;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldRascal
extends AbstractKoboldEntity {
    public boolean isFound;
    private int despawnDelay;

    public KoboldRascal(EntityType<KoboldRascal> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().f_46443_ && --this.despawnDelay <= 0) {
            this.m_146870_();
        }
    }

    public void setDespawnDelay(int i) {
        this.despawnDelay = i;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.isFound) {
            if (!this.m_9236_().m_5776_()) {
                player.m_6674_(hand);
                this.m_21195_(MobEffects.f_19609_);
                this.m_21011_(InteractionHand.MAIN_HAND, true);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    this.m_5496_((SoundEvent)KoboldsModSounds.KOBOLD_TRADE.get(), 1.0f, 1.0f);
                    ItemStack stack = new ItemStack((ItemLike)Items.f_151058_);
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128365_("Items", (Tag)new ListTag());
                    ListTag list = tag.m_128437_("Items", 10);
                    if (Math.random() >= 0.85) {
                        ItemStack loot = new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_PICKAXE.get());
                        loot.m_220157_(Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)128, (int)596), null, null);
                        EnchantmentHelper.m_220292_((RandomSource)RandomSource.m_216327_(), (ItemStack)loot, (int)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)18, (int)32), (boolean)true);
                        CompoundTag loottag = new CompoundTag();
                        loot.m_41739_(loottag);
                        list.add(0, (Tag)loottag);
                    } else {
                        int max = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)7, (int)38);
                        for (int i = 0; i < max; ++i) {
                            CompoundTag loottag;
                            Optional<CompoundTag> optional;
                            ItemStack loot = new ItemStack((ItemLike)ForgeRegistries.ITEMS.tags().getTag(KoboldsTags.RASCAL).getRandomElement(RandomSource.m_216327_()).orElseGet(() -> Items.f_42616_));
                            if (Math.random() >= 0.99) {
                                loot = new ItemStack((ItemLike)Items.f_42415_);
                            }
                            if ((optional = KoboldRascal.getMatchingItem(loot, list)).isPresent()) {
                                loottag = optional.get();
                                ItemStack bagged = ItemStack.m_41712_((CompoundTag)loottag);
                                bagged.m_41769_(loot.m_41613_());
                                bagged.m_41739_(loottag);
                                list.remove((Object)loottag);
                                list.add(0, (Tag)loottag);
                                continue;
                            }
                            loottag = new CompoundTag();
                            loot.m_41739_(loottag);
                            list.add(0, (Tag)loottag);
                        }
                    }
                    ItemEntity bundle = new ItemEntity((Level)lvl, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
                    bundle.m_32010_(10);
                    lvl.m_7967_((Entity)bundle);
                }
            }
            this.isFound = true;
        }
        for (AbstractKoboldEntity kobold : this.m_9236_().m_45976_(AbstractKoboldEntity.class, this.m_20191_().m_82400_(128.0))) {
            if (kobold == null || kobold.m_7306_((Entity)this)) continue;
            this.m_21573_().m_5624_((Entity)kobold, 1.2);
        }
        return super.m_6071_(player, hand);
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag tag) {
        return tag.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(loot -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)loot), (ItemStack)stack)).findFirst();
    }

    @Override
    protected boolean m_7808_(ItemStack drop, ItemStack hand) {
        if (drop.m_41720_() instanceof SwordItem) {
            if (!(hand.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem newbie = (SwordItem)drop.m_41720_();
            SwordItem weapon = (SwordItem)hand.m_41720_();
            if (newbie.m_43299_() != weapon.m_43299_()) {
                return newbie.m_43299_() > weapon.m_43299_();
            }
            return this.m_21477_(drop, hand);
        }
        if (drop.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)hand)) {
                return false;
            }
            if (hand.m_41619_() || hand.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (hand.m_41720_() instanceof ArmorItem) {
                ArmorItem newbie = (ArmorItem)drop.m_41720_();
                ArmorItem worn = (ArmorItem)hand.m_41720_();
                if (newbie.m_40404_() != worn.m_40404_()) {
                    return newbie.m_40404_() > worn.m_40404_();
                }
                if (newbie.m_40405_() != worn.m_40405_()) {
                    return newbie.m_40405_() > worn.m_40405_();
                }
                return this.m_21477_(drop, hand);
            }
            return false;
        }
        return false;
    }
}

