/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.raid.Raider;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldChild;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.entity.KoboldWarrior;

public class KoboldAttackSelector
implements Predicate<LivingEntity> {
    private final AbstractKoboldEntity kobold;

    public KoboldAttackSelector(AbstractKoboldEntity source) {
        this.kobold = source;
    }

    @Override
    public boolean test(@Nullable LivingEntity target) {
        if (!(this.kobold instanceof KoboldEnchanter && this.kobold instanceof KoboldChild && target instanceof ZombifiedPiglin)) {
            if (this.kobold instanceof KoboldWarrior) {
                return target instanceof Zombie || target instanceof Skeleton || target instanceof Spider || target instanceof Raider;
            }
            if (this.kobold instanceof KoboldEngineer || this.kobold instanceof KoboldRascal) {
                return target instanceof Raider;
            }
            return target instanceof Zombie || target instanceof Silverfish;
        }
        return false;
    }
}

