/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.blockentity.crafting.CraftingCubeModelData;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.util.NullConfigManager;
import appeng.util.Platform;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class CraftingBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<CraftingCPUCluster>,
IPowerChannelState,
IConfigurableObject {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private CompoundTag previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;

    public CraftingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL).addService(IGridMultiblock.class, this::getMultiblockNodes);
    }

    @Override
    protected Item getItemFromBlockEntity() {
        if (this.f_58857_ == null) {
            return Items.f_41852_;
        }
        return this.getUnitBlock().type.getItemFromType();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public AbstractCraftingUnitBlock<?> getUnitBlock() {
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return AEBlocks.CRAFTING_UNIT.block();
        }
        return (AbstractCraftingUnitBlock)this.f_58857_.m_8055_(this.f_58858_).m_60734_();
    }

    public long getStorageBytes() {
        return this.getUnitBlock().type.getStorageBytes();
    }

    public int getAcceleratorThreads() {
        return this.getUnitBlock().type.getAcceleratorThreads();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity());
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.f_58858_);
        }
    }

    public void updateMultiBlock(BlockPos changedPos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.f_58858_, changedPos);
        }
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        BlockState newState;
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        BlockState current = this.f_58857_.m_8055_(this.f_58858_);
        if (current.m_60734_() instanceof AbstractCraftingUnitBlock && current != (newState = (BlockState)((BlockState)current.m_61124_((Property)AbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).m_61124_((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.f_58857_.m_7731_(this.f_58858_, newState, 2);
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    @Override
    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.noneOf(Direction.class);
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.m_58900_().m_61143_((Property)AbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.setCoreBlock(data.m_128471_("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.m_6426_());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    @Override
    public CraftingCPUCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.cancel();
            ListCraftingInventory inv = this.cluster.craftingLogic.getInventory();
            ArrayList<BlockPos> places = new ArrayList<BlockPos>();
            for (CraftingBlockEntity blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.f_58858_);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = blockEntity.f_58858_.m_121945_(d);
                    if (!this.f_58857_.m_46859_(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (Object2LongMap.Entry entry : inv.list) {
                BlockPos position = (BlockPos)places.get(Platform.getRandomInt() % places.size());
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                ((AEKey)entry.getKey()).addDrops(entry.getLongValue(), stacks, this.f_58857_, position);
                Platform.spawnDrops(this.f_58857_, position, stacks);
            }
            inv.clear();
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AbstractCraftingUnitBlock.POWERED);
        }
        return this.getMainNode().isActive();
    }

    @Override
    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public CompoundTag getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundTag previousState) {
        this.previousState = previousState;
    }

    @Override
    public ModelData getModelData() {
        return CraftingCubeModelData.create(this.getConnections());
    }

    protected EnumSet<Direction> getConnections() {
        if (this.f_58857_ == null) {
            return EnumSet.noneOf(Direction.class);
        }
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!this.isConnected((BlockGetter)this.f_58857_, this.f_58858_, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(BlockGetter level, BlockPos pos, Direction side) {
        BlockPos adjacentPos = pos.m_121945_(side);
        return level.m_8055_(adjacentPos).m_60734_() instanceof AbstractCraftingUnitBlock;
    }

    @Override
    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.requestModelDataUpdate();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator<IGridNode>(new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), IGridConnectedBlockEntity::getGridNode);
    }

    @Override
    public IConfigManager getConfigManager() {
        CraftingCPUCluster cluster = this.getCluster();
        if (cluster != null) {
            return this.getCluster().getConfigManager();
        }
        return NullConfigManager.INSTANCE;
    }
}

