/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKeyType;
import appeng.client.gui.style.FluidBlitter;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class InitStackRenderHandlers {
    private InitStackRenderHandlers() {
    }

    public static void init() {
        AEKeyRendering.register(AEKeyType.items(), AEItemKey.class, new ItemKeyRenderHandler());
        AEKeyRendering.register(AEKeyType.fluids(), AEFluidKey.class, new FluidKeyRenderHandler());
    }

    private static class ItemKeyRenderHandler
    implements AEKeyRenderHandler<AEItemKey> {
        private ItemKeyRenderHandler() {
        }

        @Override
        public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, AEItemKey stack) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            ItemStack displayStack = stack.toStack();
            guiGraphics.m_280480_(displayStack, x, y);
            guiGraphics.m_280302_(minecraft.f_91062_, displayStack, x, y, "");
            poseStack.m_85849_();
        }

        @Override
        public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AEItemKey what, float scale, int combinedLight, Level level) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 0.01f);
            poseStack.m_252931_(new Matrix4f().scale(scale, scale, 0.001f));
            poseStack.m_85850_().m_252943_().rotateX(-0.7853982f);
            Minecraft.m_91087_().m_91291_().m_269128_(what.toStack(), ItemDisplayContext.GUI, combinedLight, OverlayTexture.f_118083_, poseStack, buffers, level, 0);
            poseStack.m_85849_();
        }

        @Override
        public Component getDisplayName(AEItemKey stack) {
            return stack.toStack().m_41786_();
        }

        @Override
        public List<Component> getTooltip(AEItemKey stack) {
            return stack.toStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        }
    }

    private static class FluidKeyRenderHandler
    implements AEKeyRenderHandler<AEFluidKey> {
        private FluidKeyRenderHandler() {
        }

        @Override
        public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, AEFluidKey what) {
            FluidBlitter.create(what).dest(x, y, 16, 16).blit(guiGraphics);
        }

        @Override
        public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AEFluidKey what, float scale, int combinedLight, Level level) {
            FluidStack fluidStack = what.toStack(1);
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)what.getFluid());
            ResourceLocation texture = renderProps.getStillTexture(fluidStack);
            int color = renderProps.getTintColor(fluidStack);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 0.01f);
            VertexConsumer buffer = buffers.m_6299_(RenderType.m_110451_());
            float x0 = -(scale -= 0.05f) / 2.0f;
            float y0 = scale / 2.0f;
            float x1 = scale / 2.0f;
            float y1 = -scale / 2.0f;
            Matrix4f transform = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(transform, x0, y1, 0.0f).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(transform, x1, y1, 0.0f).m_193479_(color).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(transform, x1, y0, 0.0f).m_193479_(color).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(transform, x0, y0, 0.0f).m_193479_(color).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
        }

        @Override
        public Component getDisplayName(AEFluidKey stack) {
            return stack.getDisplayName();
        }

        @Override
        public List<Component> getTooltip(AEFluidKey stack) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(stack.toStack(1).getDisplayName());
            String modName = Platform.formatModName(stack.getModId());
            if (tooltip.isEmpty() || !((Component)tooltip.get(tooltip.size() - 1)).getString().equals(modName)) {
                tooltip.add((Component)Component.m_237113_((String)modName));
            }
            return tooltip;
        }
    }
}

