/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.ids.AETags;
import appeng.api.movable.BlockEntityMoveStrategies;
import appeng.api.movable.IBlockEntityMoveStrategy;
import appeng.block.spatial.MatrixFrameBlock;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.server.services.compass.CompassService;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final LevelChunk[][] myChunks;
    private final Column[][] myColumns;
    private final List<BlockEntityMoveRecord> blockEntities = new ArrayList<BlockEntityMoveRecord>();
    private final List<ScheduledTick<Block>> ticks = new ArrayList<ScheduledTick<Block>>();
    private final ServerLevel level;
    private final List<BlockPos> updates = new ArrayList<BlockPos>();
    private final BlockState matrixBlockState;

    public CachedPlane(ServerLevel level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        MatrixFrameBlock matrixFrameBlock = AEBlocks.MATRIX_FRAME.block();
        this.matrixBlockState = matrixFrameBlock != null ? matrixFrameBlock.m_49966_() : null;
        this.level = level;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new LevelChunk[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(level.m_6325_(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF);
            }
        }
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                LevelChunk c;
                this.myChunks[cx][cz] = c = level.m_6325_(minCX + cx, minCZ + cz);
                ArrayList rawBlockEntities = new ArrayList(c.m_62954_().entrySet());
                for (Map.Entry entry2 : rawBlockEntities) {
                    BlockEntity blockEntity = (BlockEntity)entry2.getValue();
                    BlockPos pos = blockEntity.m_58899_();
                    if (pos.m_123341_() < minX || pos.m_123341_() > maxX || pos.m_123342_() < minY || pos.m_123342_() > maxY || pos.m_123343_() < minZ || pos.m_123343_() > maxZ || blockEntity.m_58900_().m_204336_(AETags.SPATIAL_BLACKLIST)) continue;
                    IBlockEntityMoveStrategy strategy = BlockEntityMoveStrategies.get(blockEntity);
                    CompoundTag savedData = strategy.beginMove(blockEntity);
                    if (savedData != null) {
                        this.blockEntities.add(new BlockEntityMoveRecord(strategy, blockEntity, savedData));
                        c.m_8114_((BlockPos)entry2.getKey());
                        continue;
                    }
                    BlockStorageData details = new BlockStorageData();
                    Column column = this.myColumns[pos.m_123341_() - minX][pos.m_123343_() - minZ];
                    int y = pos.m_123342_();
                    LevelChunkSection[] storage = column.c.m_7103_();
                    LevelChunkSection extendedblockstorage = storage[y >> 4];
                    details.state = extendedblockstorage.m_62982_(column.x, y & 0xF, column.z);
                    if (details.state.m_60795_()) {
                        level.m_7471_(pos, false);
                        continue;
                    }
                    this.myColumns[pos.m_123341_() - minX][pos.m_123343_() - minZ].setSkip(pos.m_123342_());
                }
                LevelChunkTicks pending = (LevelChunkTicks)c.m_183531_();
                pending.m_193196_().forEach(entry -> {
                    BlockPos pos = entry.f_193377_();
                    if (pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123342_() >= minY && pos.m_123342_() <= maxY && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ) {
                        this.ticks.add((ScheduledTick<Block>)entry);
                    }
                });
            }
        }
    }

    void swap(CachedPlane dst) {
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column srcCol = this.myColumns[x][z];
                    Column dstCol = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int n = this.y_offset + y;
                        int dst_y = dst.y_offset + y;
                        if (srcCol.doNotSkip(n) && dstCol.doNotSkip(dst_y)) {
                            BlockState dstState;
                            LevelChunkSection srcSection = srcCol.getSection(n);
                            LevelChunkSection dstSection = dstCol.getSection(dst_y);
                            BlockState srcState = srcSection.m_62982_(srcCol.x, SectionPos.m_123207_((int)n), srcCol.z);
                            if (srcState == this.matrixBlockState) {
                                srcState = Blocks.f_50016_.m_49966_();
                            }
                            if ((dstState = dstSection.m_62982_(dstCol.x, SectionPos.m_123207_((int)dst_y), dstCol.z)) == this.matrixBlockState) {
                                dstState = Blocks.f_50016_.m_49966_();
                            }
                            srcSection.m_62986_(srcCol.x, SectionPos.m_123207_((int)n), srcCol.z, dstState);
                            dstSection.m_62986_(dstCol.x, SectionPos.m_123207_((int)dst_y), dstCol.z, srcState);
                            continue;
                        }
                        this.markForUpdate(this.x_offset + x, n, this.z_offset + z);
                        dst.markForUpdate(dst.x_offset + x, dst_y, dst.z_offset + z);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (BlockEntityMoveRecord blockEntityMoveRecord : this.blockEntities) {
                BlockPos pos = blockEntityMoveRecord.blockEntity().m_58899_();
                dst.addBlockEntity(pos.m_123341_() - this.x_offset, pos.m_123342_() - this.y_offset, pos.m_123343_() - this.z_offset, blockEntityMoveRecord);
            }
            for (BlockEntityMoveRecord blockEntityMoveRecord : dst.blockEntities) {
                BlockPos pos = blockEntityMoveRecord.blockEntity().m_58899_();
                this.addBlockEntity(pos.m_123341_() - dst.x_offset, pos.m_123342_() - dst.y_offset, pos.m_123343_() - dst.z_offset, blockEntityMoveRecord);
            }
            for (ScheduledTick scheduledTick : this.ticks) {
                BlockPos movedPos = scheduledTick.f_193377_().m_7918_(-this.x_offset, -this.y_offset, -this.z_offset);
                dst.addTick(movedPos, (ScheduledTick<Block>)scheduledTick);
            }
            for (ScheduledTick scheduledTick : dst.ticks) {
                BlockPos movedPos = scheduledTick.f_193377_().m_7918_(-dst.x_offset, -dst.y_offset, -dst.z_offset);
                this.addTick(movedPos, (ScheduledTick<Block>)scheduledTick);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.updates.add(new BlockPos(x, y, z));
        for (Direction d : Direction.values()) {
            this.updates.add(new BlockPos(x + d.m_122429_(), y + d.m_122430_(), z + d.m_122431_()));
        }
    }

    private void addTick(BlockPos pos, ScheduledTick<Block> tick) {
        this.level.m_183326_().m_183393_(new ScheduledTick((Object)((Block)tick.f_193376_()), pos, tick.f_193378_(), tick.f_193379_(), tick.f_193380_()));
    }

    private void addBlockEntity(int x, int y, int z, BlockEntityMoveRecord moveRecord) {
        try {
            boolean success;
            Column c = this.myColumns[x][z];
            if (!c.doNotSkip(y + this.y_offset)) {
                AELog.warn("Block entity %s was queued to be moved from %s, but it's position then skipped during the move.", moveRecord.blockEntity(), moveRecord.blockEntity().m_58899_());
                return;
            }
            IBlockEntityMoveStrategy strategy = moveRecord.strategy();
            try {
                success = strategy.completeMove(moveRecord.blockEntity(), moveRecord.savedData(), (Level)this.level, new BlockPos(x + this.x_offset, y + this.y_offset, z + this.z_offset));
            }
            catch (Throwable e) {
                AELog.warn(e);
                success = false;
            }
            if (!success) {
                this.attemptRecovery(x, y, z, moveRecord, c);
            }
        }
        catch (Throwable e) {
            AELog.warn(e);
        }
    }

    private void attemptRecovery(int x, int y, int z, BlockEntityMoveRecord moveRecord, Column c) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntityType type = moveRecord.blockEntity().m_58903_();
        AELog.debug("Trying to recover BE %s @ %s", BlockEntityType.m_58954_((BlockEntityType)type), pos);
        BlockState blockState = moveRecord.blockEntity().m_58900_();
        BlockEntity recoveredEntity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)blockState, (CompoundTag)moveRecord.savedData());
        if (recoveredEntity != null) {
            this.level.m_7731_(pos, blockState, 3);
            c.c.m_142170_(recoveredEntity);
            this.level.m_7260_(pos, this.level.m_8055_(pos), this.level.m_8055_(pos), z);
        } else {
            AELog.warn("Failed to recover BE %s @ %s", BlockEntityType.m_58954_((BlockEntityType)type), pos);
        }
    }

    private void updateChunks() {
        LevelLightEngine lightManager = this.level.m_5518_();
        if (lightManager instanceof ThreadedLevelLightEngine) {
            ThreadedLevelLightEngine serverLightManager = (ThreadedLevelLightEngine)lightManager;
            for (int x = 0; x < this.cx_size; ++x) {
                for (int z = 0; z < this.cz_size; ++z) {
                    LevelChunk c = this.myChunks[x][z];
                    serverLightManager.m_9353_((ChunkAccess)c, false);
                    c.m_8092_(true);
                }
            }
        }
        for (int x = 0; x < this.cx_size; ++x) {
            for (int z = 0; z < this.cz_size; ++z) {
                LevelChunk c = this.myChunks[x][z];
                CompassService.updateArea(this.getLevel(), (ChunkAccess)c);
                Packet<?> cdp = Platform.getFullChunkPacket(c);
                this.level.m_7726_().f_8325_.m_183262_(c.m_7697_(), false).forEach(spe -> spe.f_8906_.m_9829_(cdp));
            }
        }
        this.level.m_7726_().m_201698_(() -> false, false);
    }

    List<BlockPos> getUpdates() {
        return this.updates;
    }

    ServerLevel getLevel() {
        return this.level;
    }

    private static class Column {
        private final int x;
        private final int z;
        private final LevelChunk c;
        private List<Integer> skipThese = null;

        public Column(LevelChunk chunk, int x, int z) {
            this.x = x;
            this.z = z;
            this.c = chunk;
        }

        private boolean doNotSkip(int y) {
            BlockState blockState = this.getSection(y).m_62982_(this.x, SectionPos.m_123207_((int)y), this.z);
            if (blockState.m_204336_(AETags.SPATIAL_BLACKLIST)) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int y) {
            if (this.skipThese == null) {
                this.skipThese = new ArrayList<Integer>();
            }
            this.skipThese.add(y);
        }

        public LevelChunkSection getSection(int y) {
            return this.c.m_183278_(this.c.m_151566_(SectionPos.m_123171_((int)y)));
        }
    }

    private record BlockEntityMoveRecord(IBlockEntityMoveStrategy strategy, BlockEntity blockEntity, CompoundTag savedData) {
    }

    private static class BlockStorageData {
        public BlockState state;

        private BlockStorageData() {
        }
    }
}

