/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.PendulumAnimation;
import net.mehvahdjukaar.amendments.common.SwingAnimation;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HangingSignTileExtension {
    @Nullable
    private ModBlockProperties.PostType leftAttachment = null;
    @Nullable
    private ModBlockProperties.PostType rightAttachment = null;
    private final boolean isCeiling;
    private boolean canSwing = true;
    private SwingAnimation animation;
    private ItemStack frontItem = ItemStack.f_41583_;
    private ItemStack backItem = ItemStack.f_41583_;

    public HangingSignTileExtension(BlockState state) {
        this.isCeiling = state.m_60734_() instanceof CeilingHangingSignBlock;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        SwingAnimation animation = this.getClientAnimation();
        if (!this.canSwing) {
            animation.reset();
        } else {
            animation.tick(level, pos, state);
        }
    }

    private Vector3f getRotationAxis(BlockState state) {
        return state.m_61138_((Property)WallHangingSignBlock.f_244390_) ? ((Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_)).m_122427_().m_253071_() : new Vector3f(0.0f, 0.0f, 1.0f).rotateY((float)Math.PI / 180 * (90.0f + RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)CeilingHangingSignBlock.f_244083_)))));
    }

    public ModBlockProperties.PostType getRightAttachment() {
        return this.rightAttachment;
    }

    public ModBlockProperties.PostType getLeftAttachment() {
        return this.leftAttachment;
    }

    public void saveAdditional(CompoundTag tag) {
        if (!this.isCeiling) {
            if (this.leftAttachment != null) {
                tag.m_128344_("left_attachment", (byte)this.leftAttachment.ordinal());
            }
            if (this.rightAttachment != null) {
                tag.m_128344_("right_attachment", (byte)this.rightAttachment.ordinal());
            }
        }
        if (!this.canSwing) {
            tag.m_128379_("can_swing", false);
        }
        if (!this.frontItem.m_41619_()) {
            tag.m_128365_("front_item", (Tag)this.frontItem.m_41739_(new CompoundTag()));
        }
        if (!this.backItem.m_41619_()) {
            tag.m_128365_("back_item", (Tag)this.backItem.m_41739_(new CompoundTag()));
        }
    }

    public void load(CompoundTag tag) {
        if (!this.isCeiling) {
            if (tag.m_128441_("left_attachment")) {
                this.leftAttachment = ModBlockProperties.PostType.values()[tag.m_128445_("left_attachment")];
            }
            if (tag.m_128441_("right_attachment")) {
                this.rightAttachment = ModBlockProperties.PostType.values()[tag.m_128445_("right_attachment")];
            }
        }
        this.canSwing = tag.m_128441_("can_swing") ? tag.m_128471_("can_swing") : true;
        if (tag.m_128441_("front_item")) {
            this.setFrontItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("front_item")));
        } else {
            this.setFrontItem(ItemStack.f_41583_);
        }
        if (tag.m_128441_("back_item")) {
            this.setBackItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("back_item")));
        } else {
            this.setBackItem(ItemStack.f_41583_);
        }
    }

    public void updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.isCeiling) {
            Direction selfFacing = (Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_);
            if (direction == selfFacing.m_122427_()) {
                this.rightAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof Level) {
                    Level l = (Level)level;
                    l.m_7260_(pos, state, state, 2);
                }
            } else if (direction == selfFacing.m_122428_()) {
                this.leftAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof Level) {
                    Level l = (Level)level;
                    l.m_7260_(pos, state, state, 2);
                }
            }
        }
        if (direction == Direction.DOWN) {
            this.updateCanSwing(state, neighborState, level, pos);
        }
    }

    private void updateCanSwing(BlockState state, BlockState neighborState, LevelAccessor level, BlockPos pos) {
        this.canSwing = this.isCeiling ? !((Boolean)state.m_61143_((Property)CeilingHangingSignBlock.f_243835_)).booleanValue() : !Amendments.canConnectDown(neighborState, level, pos);
    }

    public void updateAttachments(Level level, BlockPos pos, BlockState state) {
        if (!this.isCeiling) {
            Direction selfFacing = (Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_);
            this.rightAttachment = ModBlockProperties.PostType.get(level.m_8055_(pos.m_121945_(selfFacing.m_122427_())), true);
            this.leftAttachment = ModBlockProperties.PostType.get(level.m_8055_(pos.m_121945_(selfFacing.m_122428_())), true);
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        this.updateCanSwing(state, below, (LevelAccessor)level, pos);
    }

    public boolean canSwing() {
        return this.canSwing;
    }

    public void setFrontItem(ItemStack frontItem) {
        this.frontItem = frontItem;
    }

    public ItemStack getFrontItem() {
        return this.frontItem;
    }

    public void setBackItem(ItemStack backItem) {
        this.backItem = backItem;
    }

    public ItemStack getBackItem() {
        return this.backItem;
    }

    public SwingAnimation getClientAnimation() {
        if (this.animation == null) {
            this.animation = new PendulumAnimation(ClientConfigs.HANGING_SIGN_CONFIG, this::getRotationAxis);
        }
        return this.animation;
    }
}

