/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.common.ExtendedHangingSign;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.HangingSignDisplayItem;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WallHangingSignBlock.class})
public abstract class WallHangingSignBlockMixin
extends Block
implements EntityBlock {
    protected WallHangingSignBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")})
    public void amendments$updateExtension(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos, CallbackInfoReturnable<BlockState> cir) {
        BlockEntity blockEntity = level.m_7702_(currentPos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign tile = (ExtendedHangingSign)blockEntity;
            tile.getExtension().updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        }
    }

    @Inject(method={"canAttachTo"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/tags/TagKey;)Z")}, cancellable=true)
    public void amendments$canAttachTo(LevelReader level, BlockState state, BlockPos facingPos, Direction direction, CallbackInfoReturnable<Boolean> cir, BlockState facingState) {
        if (ModBlockProperties.BlockAttachment.get(facingState, facingPos, level, direction) != null) {
            cir.setReturnValue((Object)true);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign tile = (ExtendedHangingSign)blockEntity;
            tile.getExtension().updateAttachments(level, pos, state);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ExtendedHangingSign tile;
        BlockEntity blockEntity;
        super.m_7892_(state, level, pos, entity);
        if (level.f_46443_ && ClientConfigs.SWINGING_SIGNS.get().booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ExtendedHangingSign && (tile = (ExtendedHangingSign)blockEntity).getExtension().canSwing()) {
            tile.getExtension().getClientAnimation().hitByEntity(entity, state, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.f_46443_ ? null : (level, blockPos, blockState, blockEntity) -> {
            if (ClientConfigs.SWINGING_SIGNS.get().booleanValue() && blockEntity instanceof ExtendedHangingSign) {
                ExtendedHangingSign te = (ExtendedHangingSign)blockEntity;
                te.getExtension().clientTick(level, blockPos, blockState);
            }
        };
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void amendments$use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult ret = HangingSignDisplayItem.INSTANCE.tryPerformingAction(state, pos, level, player, hand, player.m_21120_(hand), hit);
        if (ret != InteractionResult.PASS) {
            cir.setReturnValue((Object)ret);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(super.m_49635_(state, params));
        Object object = params.m_287159_(LootContextParams.f_81462_);
        if (object instanceof ExtendedHangingSign) {
            ItemStack frontItem;
            ExtendedHangingSign tile = (ExtendedHangingSign)object;
            ItemStack backItem = tile.getExtension().getBackItem();
            if (!backItem.m_41619_()) {
                list.add(backItem);
            }
            if (!(frontItem = tile.getExtension().getFrontItem()).m_41619_()) {
                list.add(frontItem);
            }
        }
        return list;
    }
}

