/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.backteleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="teleportcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BackCommand {
    public BackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"back").requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_()) {
                if (((Boolean)PreferencesConfig.allowBackCommand.get()).booleanValue()) {
                    this.teleportBack(player);
                } else {
                    player.m_213846_((Component)Component.m_237119_().m_130946_("This back command is currently disabled"));
                    SoundManager.playSound(player, SoundEvents.f_11983_);
                }
            }
            return 0;
        }));
    }

    public void teleportBack(ServerPlayer player) {
        if (!(player.getPersistentData().m_128441_("teleportcraft:backXCoord") && player.getPersistentData().m_128441_("teleportcraft:backYCoord") && player.getPersistentData().m_128441_("teleportcraft:backZCoord") && player.getPersistentData().m_128441_("teleportcraft:backWorld"))) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("There is no location to teleport back to"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        int requiredXP = (Integer)PreferencesConfig.xpToUseBackCommand.get();
        if (player.f_36078_ < requiredXP) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("You need at least " + requiredXP + " experience levels to do this"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        String worldName = player.getPersistentData().m_128461_("teleportcraft:backWorld");
        double x = player.getPersistentData().m_128459_("teleportcraft:backXCoord");
        double y = player.getPersistentData().m_128459_("teleportcraft:backYCoord");
        double z = player.getPersistentData().m_128459_("teleportcraft:backZCoord");
        for (ServerLevel level : Objects.requireNonNull(player.m_20194_()).m_129785_()) {
            if (!level.m_46472_().m_135782_().toString().equals(worldName)) continue;
            EntityTeleportEvent.TeleportCommand event = new EntityTeleportEvent.TeleportCommand((Entity)player, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            player.m_213846_((Component)Component.m_237119_().m_130946_("Teleporting you to your previous location ..."));
            player.m_8999_(level, x, y, z, player.m_146908_(), player.m_146909_());
            player.m_9174_(player.f_36078_ - requiredXP);
            SoundManager.playSound(player, SoundEvents.f_11852_);
            return;
        }
        player.m_213846_((Component)Component.m_237119_().m_130946_("Failed to teleport back because the world was not found"));
        SoundManager.playSound(player, SoundEvents.f_11983_);
    }

    @SubscribeEvent
    public static void onTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            String backWorld = player.m_284548_().m_46472_().m_135782_().toString();
            player.getPersistentData().m_128347_("teleportcraft:backXCoord", event.getPrevX());
            player.getPersistentData().m_128347_("teleportcraft:backYCoord", event.getPrevY());
            player.getPersistentData().m_128347_("teleportcraft:backZCoord", event.getPrevZ());
            player.getPersistentData().m_128359_("teleportcraft:backWorld", backWorld);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        double x = event.getOriginal().getPersistentData().m_128459_("teleportcraft:backXCoord");
        double y = event.getOriginal().getPersistentData().m_128459_("teleportcraft:backYCoord");
        double z = event.getOriginal().getPersistentData().m_128459_("teleportcraft:backZCoord");
        String worldName = event.getOriginal().getPersistentData().m_128461_("teleportcraft:backWorld");
        Player player = event.getEntity();
        player.getPersistentData().m_128347_("teleportcraft:backXCoord", x);
        player.getPersistentData().m_128347_("teleportcraft:backYCoord", y);
        player.getPersistentData().m_128347_("teleportcraft:backZCoord", z);
        player.getPersistentData().m_128359_("teleportcraft:backWorld", worldName);
    }
}

