/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public abstract class OnboardingScreenBase
extends Screen {
    public static final Component NEXT = Component.m_237115_((String)"message.voicechat.onboarding.next");
    public static final Component BACK = Component.m_237115_((String)"message.voicechat.onboarding.back");
    public static final Component CANCEL = Component.m_237115_((String)"message.voicechat.onboarding.cancel");
    protected static final int TEXT_COLOR = -1;
    protected static final int PADDING = 8;
    protected static final int SMALL_PADDING = 2;
    protected static final int BUTTON_HEIGHT = 20;
    protected int contentWidth;
    protected int guiLeft;
    protected int guiTop;
    protected int contentHeight;
    @Nullable
    protected Screen previous;

    public OnboardingScreenBase(Component title, @Nullable Screen previous) {
        super(title);
        this.previous = previous;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.contentWidth = this.f_96543_ / 2;
        this.guiLeft = (this.f_96543_ - this.contentWidth) / 2;
        this.guiTop = 20;
        this.contentHeight = this.f_96544_ - this.guiTop * 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Nullable
    public Screen getNextScreen() {
        return null;
    }

    protected void addPositiveButton(Component text, Button.OnPress onPress) {
        Button nextButton = Button.m_253074_((Component)text, (Button.OnPress)onPress).m_252987_(this.guiLeft + this.contentWidth / 2 + 4, this.guiTop + this.contentHeight - 20, this.contentWidth / 2 - 4, 20).m_253136_();
        this.m_142416_((GuiEventListener)nextButton);
    }

    protected void addNextButton() {
        this.addPositiveButton(NEXT, button -> this.f_96541_.m_91152_(this.getNextScreen()));
    }

    protected void addBackOrCancelButton(boolean big) {
        Component text = CANCEL;
        if (this.previous instanceof OnboardingScreenBase) {
            text = BACK;
        }
        Button cancel = Button.m_253074_((Component)text, button -> this.f_96541_.m_91152_(this.previous)).m_252987_(this.guiLeft, this.guiTop + this.contentHeight - 20, big ? this.contentWidth : this.contentWidth / 2 - 4, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancel);
    }

    protected void addBackOrCancelButton() {
        this.addBackOrCancelButton(false);
    }

    protected void renderTitle(GuiGraphics guiGraphics, Component titleComponent) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)titleComponent);
        guiGraphics.m_280649_(this.f_96547_, titleComponent.m_7532_(), this.f_96543_ / 2 - titleWidth / 2, this.guiTop, -1, true);
    }

    protected void renderMultilineText(GuiGraphics guiGraphics, Component textComponent) {
        List text = this.f_96547_.m_92923_((FormattedText)textComponent, this.contentWidth);
        for (int i = 0; i < text.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)text.get(i);
            int n = this.f_96543_ / 2 - this.f_96547_.m_92724_(line) / 2;
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(this.f_96547_, line, n, this.guiTop + 9 + 20 + i * (9 + 1), -1, true);
        }
    }
}

