/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.stamina;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.plugin.PluginAction;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.api.stamina.StaminaFactory;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.api.stamina.StaminaPluginAction;
import tictim.paraglider.impl.stamina.BotWStaminaFactory;
import tictim.paraglider.plugin.ParagliderPluginLoader;
import tictim.paraglider.plugin.ParagliderPluginUtils;

public final class StaminaFactoryLoader {
    private StaminaFactoryLoader() {
    }

    @NotNull
    public static StaminaFactory loadStaminaFactory() {
        return StaminaFactoryLoader.loadStaminaFactory(ParagliderPluginLoader.get().getStaminaPlugins());
    }

    @NotNull
    private static StaminaFactory loadStaminaFactory(@NotNull @NotNull List<@NotNull PluginInstance<StaminaPlugin>> plugins) {
        ArrayList factories = new ArrayList();
        for (PluginInstance<StaminaPlugin> plugin : plugins) {
            StaminaFactory factory = plugin.instance().getStaminaFactory();
            if (factory == null) continue;
            factories.add(new PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>(plugin, new StaminaPluginAction.ProvideStaminaFactory(factory)));
        }
        return switch (factories.size()) {
            case 0 -> new BotWStaminaFactory();
            case 1 -> ((StaminaPluginAction.ProvideStaminaFactory)((PluginAction)factories.get(0)).action()).factory();
            default -> {
                List resolved = ParagliderPluginUtils.resolve(StaminaPlugin::getStaminaPluginConflictResolver, factories);
                if (resolved == null) {
                    throw ParagliderPluginUtils.composePluginLoadingError(factories);
                }
                switch (resolved.size()) {
                    case 0: {
                        yield new BotWStaminaFactory();
                    }
                    case 1: {
                        yield ((StaminaPluginAction.ProvideStaminaFactory)resolved.get(0).action()).factory();
                    }
                }
                throw ParagliderPluginUtils.composePluginLoadingError(factories);
            }
        };
    }
}

