/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

@ApiSide.ClientOnly
public class ItemListComponent
implements ITooltipComponent.HorizontalGrowing {
    private final List<ItemStack> items;
    private final int maxHeight;
    private int gridWidth;
    private int gridHeight;
    private int maxIndex;

    public ItemListComponent(List<ItemStack> items) {
        this(items, 3);
    }

    public ItemListComponent(List<ItemStack> items, int maxHeight) {
        this.items = items;
        this.maxHeight = maxHeight;
    }

    @Override
    public int getMinimalWidth() {
        return Math.min(this.items.size(), 9) * 18;
    }

    @Override
    public void setGrownWidth(int grownWidth) {
        this.gridWidth = grownWidth / 18;
        this.gridHeight = this.items.isEmpty() ? 0 : Math.min(Mth.m_184652_((int)this.items.size(), (int)this.gridWidth), this.maxHeight);
        this.maxIndex = this.gridWidth * this.gridHeight - 1;
    }

    @Override
    public int getHeight() {
        return this.gridHeight * 18;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, float delta) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = this.items.get(i);
            int ix = x + 18 * (i % this.gridWidth) + 1;
            int iy = y + 18 * (i / this.gridWidth) + 1;
            ctx.m_280480_(item, ix, iy);
            ItemComponent.renderItemDecorations(ctx, item, ix, iy);
            if (i == this.maxIndex) break;
        }
    }
}

