/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public interface ILightable {
    public static final TagKey<Item> FLINT_AND_STEELS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "tools/flint_and_steel"));

    default public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return this.isLitUp(state);
    }

    default public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        world.m_7731_(pos, this.toggleLitState(state, lit), 3);
    }

    @Deprecated(forRemoval=true)
    default public boolean isLitUp(BlockState state) {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public BlockState toggleLitState(BlockState state, boolean lit) {
        return state;
    }

    default public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, FireSourceType fireSourceType) {
        if (!this.isLitUp(state, (BlockGetter)world, pos)) {
            if (!world.m_5776_()) {
                this.setLitUp(state, world, pos, true);
                this.playLightUpSound(world, pos, fireSourceType);
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    default public boolean extinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        if (this.isLitUp(state, (BlockGetter)world, pos)) {
            if (!world.m_5776_()) {
                this.playExtinguishSound(world, pos);
                this.setLitUp(state, world, pos, false);
            } else {
                this.spawnSmokeParticles(state, pos, world);
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    default public boolean interactWithProjectile(Level level, BlockState state, Projectile projectile, BlockPos pos) {
        Entity entity;
        return projectile.m_6060_() && ((entity = projectile.m_19749_()) == null || entity instanceof Player || PlatHelper.isMobGriefingOn(level, entity)) && this.lightUp((Entity)projectile, state, pos, (LevelAccessor)level, FireSourceType.FLAMING_ARROW);
    }

    default public InteractionResult interactWithPlayer(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (Utils.mayPerformBlockAction(player, pos, stack)) {
            if (!this.isLitUp(state, (BlockGetter)level, pos)) {
                Item item = stack.m_41720_();
                if (item instanceof FlintAndSteelItem || stack.m_204117_(FLINT_AND_STEELS)) {
                    if (this.lightUp((Entity)player, state, pos, (LevelAccessor)level, FireSourceType.FLINT_AND_STEEL)) {
                        stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                } else if (item instanceof FireChargeItem && this.lightUp((Entity)player, state, pos, (LevelAccessor)level, FireSourceType.FIRE_CHANGE)) {
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (this.canBeExtinguishedBy(stack) && this.extinguish((Entity)player, state, pos, (LevelAccessor)level) && !(stack.m_41720_() instanceof BrushItem)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    default public boolean canBeExtinguishedBy(ItemStack item) {
        return item.m_41720_() instanceof ShovelItem || item.m_41720_() instanceof BrushItem;
    }

    default public void playLightUpSound(LevelAccessor world, BlockPos pos, FireSourceType type) {
        type.play(world, pos);
    }

    default public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor world) {
        RandomSource random = world.m_213780_();
        for (int i = 0; i < 10; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.25f + random.m_188501_() * 0.5f), (double)((float)pos.m_123342_() + 0.35f + random.m_188501_() * 0.5f), (double)((float)pos.m_123343_() + 0.25f + random.m_188501_() * 0.5f), 0.0, 0.005, 0.0);
        }
    }

    @FunctionalInterface
    public static interface FireSourceType {
        public static final FireSourceType FLINT_AND_STEEL = (level, pos) -> level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        public static final FireSourceType FIRE_CHANGE = (level, pos) -> level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
        public static final FireSourceType FLAMING_ARROW = (level, pos) -> level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.5f, 1.4f);

        public void play(LevelAccessor var1, BlockPos var2);
    }
}

