/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImprovedProjectileEntity
extends ThrowableItemProjectile {
    protected Vec3 movementOld = this.m_20184_();
    protected boolean isStuck = false;
    protected int stuckTime = 0;
    protected int maxAge = 300;
    protected int maxStuckTime = 20;
    @Deprecated(forRemoval=true)
    public boolean touchedGround;
    @Deprecated(forRemoval=true)
    public int groundTime = 0;

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level world) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, LivingEntity thrower, Level world) {
        this(type, thrower.m_20185_(), thrower.m_20188_() - (double)0.1f, thrower.m_20189_(), world);
        this.m_5602_((Entity)thrower);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    public void m_8119_() {
        Vec3 movement;
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.f_150164_ = true;
        }
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        this.m_6075_();
        if (this.hasReachedEndOfLife() && !this.m_213877_()) {
            this.reachedEndOfLife();
        }
        Level level = this.m_9236_();
        this.movementOld = movement = this.m_20184_();
        if (this.f_19865_.m_82556_() > 1.0E-7) {
            movement = movement.m_82559_(this.f_19865_);
            this.f_19865_ = Vec3.f_82478_;
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.f_19794_ && this.isStuck) {
            ++this.stuckTime;
        }
        this.m_6478_(MoverType.SELF, movement);
        this.m_146872_();
        this.updateFireState();
        float deceleration = this.m_20069_() ? this.getWaterInertia() : this.getInertia();
        this.m_20256_(this.m_20184_().m_82490_((double)deceleration));
        if (!this.m_20068_() && !this.f_19794_) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, (double)this.m_7139_(), 0.0));
        }
        if (!this.isStuck) {
            if (level.f_46443_) {
                this.spawnTrailParticles();
            }
            this.m_37283_();
        }
    }

    private void updateFireState() {
        this.f_146810_ = this.m_6060_();
        if (this.m_9236_().m_46847_(this.m_20191_().m_82406_(1.0E-6)).noneMatch(arg -> arg.m_204336_(BlockTags.f_13076_) || arg.m_60713_(Blocks.f_49991_))) {
            if (this.m_20094_() <= 0) {
                this.m_7311_(-this.m_6101_());
            }
            if (this.f_146810_ && (this.f_146808_ || this.m_20071_() || ForgeHelper.isInFluidThatCanExtinguish((Entity)this))) {
                this.m_146873_();
            }
        }
        if (this.m_6060_() && (this.f_146808_ || this.m_20071_() || ForgeHelper.isInFluidThatCanExtinguish((Entity)this))) {
            this.m_7311_(-this.m_6101_());
        }
    }

    public void m_6478_(MoverType moverType, Vec3 movement) {
        if (moverType != MoverType.SELF) {
            super.m_6478_(moverType, movement);
            return;
        }
        movement = this.m_5763_(movement, moverType);
        Level level = this.m_9236_();
        Vec3 pos = this.m_20182_();
        ColliderType colliderType = this.getColliderType();
        BlockHitResult hitResult = switch (colliderType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> level.m_45547_(new ClipContext(pos, pos.m_82549_(movement), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            case 1 -> MthUtils.collideWithSweptAABB((Entity)this, movement, 2.0);
            case 2 -> {
                Vec3 vec3 = this.m_20272_(movement);
                Vec3 sub = vec3.m_82546_(movement);
                if (vec3 == movement) {
                    yield BlockHitResult.m_82426_((Vec3)pos.m_82549_(vec3), (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)pos.m_82549_(vec3)));
                }
                yield new BlockHitResult(pos.m_82549_(vec3), Direction.m_122366_((double)sub.f_82479_, (double)sub.f_82480_, (double)sub.f_82481_), BlockPos.m_274446_((Position)pos.m_82549_(vec3)), false);
            }
        };
        Vec3 newPos = hitResult.m_82450_();
        Vec3 newMovement = newPos.m_82546_(pos);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        boolean bl = !Mth.m_14082_((double)newMovement.f_82479_, (double)movement.f_82479_);
        boolean bl2 = !Mth.m_14082_((double)newMovement.f_82481_, (double)movement.f_82481_);
        this.f_19862_ = bl || bl2;
        this.f_19863_ = newMovement.f_82480_ != movement.f_82480_;
        this.f_201939_ = this.f_19863_ && newMovement.f_82480_ < 0.0;
        this.f_185931_ = this.f_19862_ ? this.m_196406_(newMovement) : false;
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)this, (Vec3)pos, (Vec3)newPos, (AABB)this.m_20191_().m_82369_(newPos.m_82546_(pos)).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0));
        if (entityHitResult != null) {
            hitResult = entityHitResult;
        }
        boolean portalHit = false;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult ei = (EntityHitResult)hitResult;
            Entity hitEntity = ei.m_82443_();
            if (hitEntity == this.m_19749_()) {
                if (!this.canHarmOwner()) {
                    hitResult = null;
                }
            } else if (hitEntity instanceof Player) {
                Player p2;
                Player p1 = (Player)hitEntity;
                Entity entity = this.m_19749_();
                if (entity instanceof Player && !(p2 = (Player)entity).m_7099_(p1)) {
                    hitResult = null;
                }
            }
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult bi = hitResult;
            BlockPos hitPos = bi.m_82425_();
            BlockState hitState = level.m_8055_(hitPos);
            if (hitState.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(hitPos);
                portalHit = true;
            } else if (hitState.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockEntity = level.m_7702_(hitPos);
                if (blockEntity instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity tile = (TheEndGatewayBlockEntity)blockEntity;
                    if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)level, (BlockPos)hitPos, (BlockState)hitState, (Entity)this, (TheEndGatewayBlockEntity)tile);
                    }
                }
                portalHit = true;
            }
        }
        if (!portalHit && hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS && !ForgeHelper.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_((HitResult)hitResult);
        }
    }

    public boolean canHarmOwner() {
        if (this.m_19749_() instanceof Player) {
            return this.m_9236_().m_46791_().m_19028_() >= 1;
        }
        return false;
    }

    protected float getInertia() {
        return 0.99f;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean hasReachedEndOfLife() {
        return this.f_19797_ > this.maxAge || this.stuckTime > this.maxStuckTime;
    }

    public void reachedEndOfLife() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Deprecated(forRemoval=true)
    public void spawnTrailParticles(Vec3 oldPos, Vec3 newPos) {
    }

    public void spawnTrailParticles() {
        this.spawnTrailParticles(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_());
        if (this.m_20069_()) {
            Vec3 movement = this.m_20184_();
            double velX = movement.f_82479_;
            double velY = movement.f_82480_;
            double velZ = movement.f_82481_;
            for (int j = 0; j < 4; ++j) {
                double pY = this.m_20188_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - velX * 0.25, pY - velY * 0.25, this.m_20189_() - velZ * 0.25, velX, velY, velZ);
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("stuck", this.isStuck);
        tag.m_128405_("stuckTime", this.stuckTime);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.isStuck = tag.m_128471_("stuck");
        this.stuckTime = tag.m_128451_("stuckTime");
    }

    public void m_37251_(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.m_37251_(shooter, x, y, z, velocity, inaccuracy);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public float getDefaultShootVelocity() {
        return 1.5f;
    }

    @Deprecated(forRemoval=true)
    public void setNoPhysics(boolean noGravity) {
        super.m_20242_(noGravity);
    }

    @Deprecated(forRemoval=true)
    public boolean isNoPhysics() {
        return super.m_20068_();
    }

    @Deprecated(forRemoval=true)
    protected float getDeceleration() {
        return 0.99f;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 oPos, Vec3 pos) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)oPos, (Vec3)pos, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0));
    }

    protected ColliderType getColliderType() {
        return ColliderType.AABB;
    }

    protected static enum ColliderType {
        RAY,
        AABB,
        ENTITY_COLLIDE;

    }
}

